/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.executionoutbox.restclient.integtests;

import java.util.List;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.apache.isis.applib.services.iactnlayer.InteractionService;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.core.config.presets.IsisPresets;
import org.apache.isis.core.runtimeservices.IsisModuleCoreRuntimeServices;
import org.apache.isis.core.webapp.IsisModuleCoreWebapp;
import org.apache.isis.extensions.executionoutbox.applib.dom.ExecutionOutboxEntryRepository;
import org.apache.isis.extensions.executionoutbox.applib.integtest.model.CounterRepository;
import org.apache.isis.extensions.executionoutbox.applib.integtest.model.Counter_bumpUsingMixin;
import org.apache.isis.extensions.executionoutbox.applib.integtest.model.Counter_bumpUsingMixinWithExecutionPublishingDisabled;
import org.apache.isis.extensions.executionoutbox.jpa.IsisModuleExtExecutionOutboxPersistenceJpa;
import org.apache.isis.extensions.executionoutbox.jpa.dom.ExecutionOutboxEntry;
import org.apache.isis.extensions.executionoutbox.jpa.integtests.model.Counter;
import org.apache.isis.extensions.executionoutbox.restclient.api.OutboxClient;
import org.apache.isis.extensions.executionoutbox.restclient.integtests.RestEndpointService;
import org.apache.isis.persistence.jpa.eclipselink.IsisModulePersistenceJpaEclipselink;
import org.apache.isis.schema.ixn.v2.InteractionDto;
import org.apache.isis.security.bypass.IsisModuleSecurityBypass;
import org.apache.isis.testing.fixtures.applib.IsisModuleTestingFixturesApplib;
import org.apache.isis.viewer.restfulobjects.jaxrsresteasy4.IsisModuleViewerRestfulObjectsJaxrsResteasy4;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.transaction.annotation.Propagation;

@SpringBootTest(classes={AppManifest.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"test"})
public class OutboxRestClient_IntegTest {
    @LocalServerPort
    protected int port;
    org.apache.isis.extensions.executionoutbox.applib.integtest.model.Counter counter1;
    org.apache.isis.extensions.executionoutbox.applib.integtest.model.Counter counter2;
    OutboxClient outboxClient;
    @Inject
    RestEndpointService restEndpointService;
    @Inject
    ExecutionOutboxEntryRepository<? extends org.apache.isis.extensions.executionoutbox.applib.dom.ExecutionOutboxEntry> executionOutboxEntryRepository;
    @Inject
    InteractionService interactionService;
    @Inject
    RepositoryService repositoryService;
    @Inject
    CounterRepository counterRepository;
    @Inject
    WrapperFactory wrapperFactory;
    @Inject
    TransactionService transactionService;

    @BeforeAll
    static void beforeAll() {
        IsisPresets.forcePrototyping();
    }

    @BeforeEach
    void beforeEach() {
        this.interactionService.runAnonymous(() -> this.transactionService.runTransactional(Propagation.REQUIRED, () -> {
            this.counterRepository.removeAll();
            this.executionOutboxEntryRepository.removeAll();
            Assertions.assertThat((List)this.counterRepository.find()).isEmpty();
            this.counter1 = this.counterRepository.persist((org.apache.isis.extensions.executionoutbox.applib.integtest.model.Counter)Counter.builder().name("counter-1").build());
            this.counter2 = this.counterRepository.persist((org.apache.isis.extensions.executionoutbox.applib.integtest.model.Counter)Counter.builder().name("counter-2").build());
            Assertions.assertThat((List)this.counterRepository.find()).hasSize(2);
            List all = this.executionOutboxEntryRepository.findOldest();
            Assertions.assertThat((List)all).isEmpty();
        }));
        this.outboxClient = this.restEndpointService.newClient(this.port, "any", "any-password-because-security-bypass-module-is-configured").withReadTimeoutInSecs(3000);
    }

    @Test
    void pending_when_none() {
        List pending = this.outboxClient.pending();
        Assertions.assertThat((List)pending).hasSize(0);
    }

    @Test
    void pending_when_many() {
        this.interactionService.runAnonymous(() -> {
            this.counter1 = this.counterRepository.findByName("counter-1");
            ((Counter_bumpUsingMixin)this.wrapperFactory.wrapMixin(Counter_bumpUsingMixin.class, (Object)this.counter1)).act();
            ((org.apache.isis.extensions.executionoutbox.applib.integtest.model.Counter)this.wrapperFactory.wrap((Object)this.counter1)).bumpUsingDeclaredAction();
            ((org.apache.isis.extensions.executionoutbox.applib.integtest.model.Counter)this.wrapperFactory.wrap((Object)this.counter1)).setNum(Long.valueOf(99L));
        });
        this.interactionService.runAnonymous(() -> {
            List all = this.executionOutboxEntryRepository.findOldest();
            Assertions.assertThat((List)all).hasSize(3);
        });
        List pending = this.outboxClient.pending();
        Assertions.assertThat((List)pending).hasSize(3);
    }

    @Test
    void scenario() {
        this.interactionService.runAnonymous(() -> {
            this.counter1 = this.counterRepository.findByName("counter-1");
            this.bump(this.counter1, 1);
        });
        this.interactionService.runAnonymous(() -> {
            List all = this.repositoryService.allInstances(ExecutionOutboxEntry.class);
            Assertions.assertThat((List)all).hasSize(1);
            List oldest = this.executionOutboxEntryRepository.findOldest();
            Assertions.assertThat((List)oldest).hasSize(1);
        });
        List pending = this.outboxClient.pending();
        Assertions.assertThat((List)pending).hasSize(1);
        String interactionId = ((InteractionDto)pending.get(0)).getInteractionId();
        int sequence = ((InteractionDto)pending.get(0)).getExecution().getSequence();
        this.outboxClient.delete(interactionId, sequence);
        this.interactionService.runAnonymous(() -> {
            List all = this.repositoryService.allInstances(ExecutionOutboxEntry.class);
            Assertions.assertThat((List)all).hasSize(0);
            List oldest = this.executionOutboxEntryRepository.findOldest();
            Assertions.assertThat((List)oldest).hasSize(0);
        });
        this.interactionService.runAnonymous(() -> {
            this.counter1 = this.counterRepository.findByName("counter-1");
            this.counter2 = this.counterRepository.findByName("counter-2");
            this.bump(this.counter1, 30);
            this.bump(this.counter2, 30);
            this.bump(this.counter1, 40);
            this.bump(this.counter2, 40);
        });
        this.interactionService.runAnonymous(() -> {
            List all = this.repositoryService.allInstances(ExecutionOutboxEntry.class);
            Assertions.assertThat((List)all).hasSize(140);
            List oldest = this.executionOutboxEntryRepository.findOldest();
            Assertions.assertThat((List)oldest).hasSize(100);
        });
        List pending2 = this.outboxClient.pending();
        Assertions.assertThat((List)pending2).hasSize(100);
        List interactionsToDelete = pending2.subList(0, 50);
        this.outboxClient.deleteMany(interactionsToDelete);
        this.interactionService.runAnonymous(() -> {
            List all = this.repositoryService.allInstances(ExecutionOutboxEntry.class);
            Assertions.assertThat((List)all).hasSize(90);
        });
        List pending3 = this.outboxClient.pending();
        Assertions.assertThat((List)pending3).hasSize(90);
    }

    private void bump(org.apache.isis.extensions.executionoutbox.applib.integtest.model.Counter counter, int numberOfTimes) {
        IntStream.range(0, numberOfTimes).forEach(x -> ((Counter_bumpUsingMixin)this.wrapperFactory.wrapMixin(Counter_bumpUsingMixin.class, (Object)counter)).act());
    }

    @EnableAutoConfiguration
    @Configuration
    @Import(value={IsisModuleCoreRuntimeServices.class, IsisModuleSecurityBypass.class, IsisModulePersistenceJpaEclipselink.class, IsisModuleTestingFixturesApplib.class, IsisModuleExtExecutionOutboxPersistenceJpa.class, IsisModuleViewerRestfulObjectsJaxrsResteasy4.class, IsisModuleCoreWebapp.class, Counter_bumpUsingMixin.class, Counter_bumpUsingMixinWithExecutionPublishingDisabled.class})
    @PropertySources(value={@PropertySource(value={"classpath:/org/apache/isis/core/config/presets/UseLog4j2Test.properties"})})
    @EntityScan(basePackageClasses={Counter.class})
    @ComponentScan(basePackageClasses={AppManifest.class, Counter.class})
    public static class AppManifest {
    }
}

