/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.executionoutbox.applib.restapi;

import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Publishing;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.util.schema.InteractionsDtoUtils;
import org.apache.isis.extensions.executionoutbox.applib.dom.ExecutionOutboxEntry;
import org.apache.isis.extensions.executionoutbox.applib.dom.ExecutionOutboxEntryRepository;
import org.apache.isis.extensions.executionoutbox.applib.restapi.OutboxEvents;
import org.apache.isis.schema.ixn.v2.InteractionsDto;

@Named(value="isis.ext.executionOutbox.OutboxRestApi")
@DomainService(nature=NatureOfService.REST)
public class OutboxRestApi {
    static final String LOGICAL_TYPE_NAME = "isis.ext.executionOutbox.OutboxRestApi";
    @Inject
    final ExecutionOutboxEntryRepository<? extends ExecutionOutboxEntry> entryRepository;
    @Inject
    FactoryService factoryService;

    @Action(semantics=SemanticsOf.SAFE, executionPublishing=Publishing.DISABLED, commandPublishing=Publishing.DISABLED)
    public OutboxEvents pending() {
        OutboxEvents outboxEvents = (OutboxEvents)this.factoryService.viewModel((Object)new OutboxEvents());
        List<? extends ExecutionOutboxEntry> entries = this.entryRepository.findOldest();
        outboxEvents.getExecutions().addAll(entries);
        return outboxEvents;
    }

    @Action(semantics=SemanticsOf.IDEMPOTENT, executionPublishing=Publishing.DISABLED, commandPublishing=Publishing.DISABLED)
    public void delete(String interactionId, int sequence) {
        this.entryRepository.deleteByInteractionIdAndSequence(UUID.fromString(interactionId), sequence);
    }

    @Action(semantics=SemanticsOf.IDEMPOTENT, executionPublishing=Publishing.DISABLED, commandPublishing=Publishing.DISABLED)
    public void deleteMany(String interactionsDtoXml) {
        InteractionsDto interactionsDto = InteractionsDtoUtils.fromXml((String)interactionsDtoXml);
        interactionsDto.getInteractionDto().forEach(interactionType -> {
            String interactionId = interactionType.getInteractionId();
            int sequence = interactionType.getExecution().getSequence();
            this.entryRepository.deleteByInteractionIdAndSequence(UUID.fromString(interactionId), sequence);
        });
    }

    public OutboxRestApi(ExecutionOutboxEntryRepository<? extends ExecutionOutboxEntry> entryRepository) {
        this.entryRepository = entryRepository;
    }
}

