/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.executionoutbox.applib.dom;

import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.exceptions.RecoverableException;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.iactn.Execution;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.applib.util.schema.InteractionDtoUtils;
import org.apache.isis.core.config.environment.IsisSystemEnvironment;
import org.apache.isis.extensions.executionoutbox.applib.dom.ExecutionOutboxEntry;
import org.apache.isis.extensions.executionoutbox.applib.dom.ExecutionOutboxEntryType;
import org.apache.isis.schema.ixn.v2.InteractionDto;

public abstract class ExecutionOutboxEntryRepository<E extends ExecutionOutboxEntry> {
    public static final String LOGICAL_TYPE_NAME = "isis.ext.executionOutbox.ExecutionOutboxEntryRepository";
    private final Class<E> executionOutboxEntryClass;
    @Inject
    Provider<RepositoryService> repositoryServiceProvider;
    @Inject
    FactoryService factoryService;
    @Inject
    IsisSystemEnvironment isisSystemEnvironment;

    protected ExecutionOutboxEntryRepository(Class<E> executionOutboxEntryClass) {
        this.executionOutboxEntryClass = executionOutboxEntryClass;
    }

    public Class<E> getEntityClass() {
        return this.executionOutboxEntryClass;
    }

    protected ExecutionOutboxEntryRepository(Class<E> executionOutboxEntryClass, Provider<RepositoryService> repositoryServiceProvider, FactoryService factoryService) {
        this.executionOutboxEntryClass = executionOutboxEntryClass;
        this.repositoryServiceProvider = repositoryServiceProvider;
        this.factoryService = factoryService;
    }

    public E createEntryAndPersist(Execution execution) {
        ExecutionOutboxEntry e = (ExecutionOutboxEntry)this.factoryService.detachedEntity(this.executionOutboxEntryClass);
        e.init(execution);
        this.persist(e);
        return (E)e;
    }

    public Optional<E> findByInteractionIdAndSequence(UUID interactionId, int sequence) {
        return this.repositoryService().firstMatch((Query)Query.named(this.executionOutboxEntryClass, (String)"isis.ext.executionOutbox.ExecutionOutboxEntry.findByInteractionIdAndSequence").withParameter("interactionId", (Object)interactionId).withParameter("sequence", (Object)sequence));
    }

    public List<E> findOldest() {
        return this.repositoryService().allMatches(Query.named(this.executionOutboxEntryClass, (String)"isis.ext.executionOutbox.ExecutionOutboxEntry.findOldest").withLimit(100L));
    }

    public ExecutionOutboxEntry upsert(UUID interactionId, int sequence, ExecutionOutboxEntryType executionType, Timestamp startedAt, String username, Bookmark target, String logicalMemberIdentifier, String xml) {
        return this.upsert(interactionId, sequence, executionType, startedAt, username, target, logicalMemberIdentifier, InteractionDtoUtils.fromXml((String)xml));
    }

    public ExecutionOutboxEntry upsert(UUID interactionId, int sequence, ExecutionOutboxEntryType executionType, Timestamp startedAt, String username, Bookmark target, String logicalMemberIdentifier, InteractionDto interactionDto) {
        return this.findByInteractionIdAndSequence(interactionId, sequence).orElseGet(() -> {
            ExecutionOutboxEntry outboxEvent = (ExecutionOutboxEntry)this.factoryService.detachedEntity(this.executionOutboxEntryClass);
            outboxEvent.setExecutionType(executionType);
            outboxEvent.setInteractionId(interactionId);
            outboxEvent.setTimestamp(startedAt);
            outboxEvent.setSequence(sequence);
            outboxEvent.setUsername(username);
            outboxEvent.setTarget(target);
            outboxEvent.setLogicalMemberIdentifier(logicalMemberIdentifier);
            outboxEvent.setInteractionDto(interactionDto);
            this.repositoryService().persist((Object)outboxEvent);
            return outboxEvent;
        });
    }

    protected abstract E newExecutionOutboxEntry();

    @Programmatic
    public boolean deleteByInteractionIdAndSequence(UUID interactionId, int sequence) {
        Optional<E> outboxEventIfAny = this.findByInteractionIdAndSequence(interactionId, sequence);
        if (outboxEventIfAny.isPresent()) {
            this.repositoryService().removeAndFlush(outboxEventIfAny.get());
            return true;
        }
        return false;
    }

    private void persist(E commandLogEntry) {
        this.repositoryService().persist(commandLogEntry);
    }

    private RepositoryService repositoryService() {
        return (RepositoryService)this.repositoryServiceProvider.get();
    }

    public List<E> findAll() {
        if (this.isisSystemEnvironment.getDeploymentType().isProduction()) {
            throw new IllegalStateException("Cannot removeAll in production systems");
        }
        return this.repositoryService().allInstances(this.executionOutboxEntryClass);
    }

    public void removeAll() {
        if (this.isisSystemEnvironment.getDeploymentType().isProduction()) {
            throw new IllegalStateException("Cannot removeAll in production systems");
        }
        this.repositoryService().removeAll(this.executionOutboxEntryClass);
    }

    public static class NotFoundException
    extends RecoverableException {
        private static final long serialVersionUID = 1L;
        private final UUID interactionId;

        public NotFoundException(UUID interactionId) {
            super("Execution log entry not found");
            this.interactionId = interactionId;
        }

        public UUID getInteractionId() {
            return this.interactionId;
        }
    }
}

