/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.executionoutbox.applib.dom;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.Digits;
import lombok.NonNull;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.annotation.Editing;
import org.apache.isis.applib.annotation.ObjectSupport;
import org.apache.isis.applib.annotation.Optionality;
import org.apache.isis.applib.annotation.Parameter;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.applib.annotation.Publishing;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.mixins.system.DomainChangeRecord;
import org.apache.isis.applib.mixins.system.HasInteractionIdAndSequence;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.iactn.ActionInvocation;
import org.apache.isis.applib.services.iactn.Execution;
import org.apache.isis.applib.services.iactn.HasInteractionDto;
import org.apache.isis.applib.services.iactn.PropertyEdit;
import org.apache.isis.applib.services.tablecol.TableColumnOrderForCollectionTypeAbstract;
import org.apache.isis.applib.util.ObjectContracts;
import org.apache.isis.applib.util.TitleBuffer;
import org.apache.isis.applib.util.ToString;
import org.apache.isis.commons.internal.base._Temporals;
import org.apache.isis.extensions.executionoutbox.applib.IsisModuleExtExecutionOutboxApplib;
import org.apache.isis.extensions.executionoutbox.applib.dom.ExecutionOutboxEntryType;
import org.apache.isis.schema.common.v2.OidDto;
import org.apache.isis.schema.ixn.v2.InteractionDto;
import org.apache.isis.schema.ixn.v2.MemberExecutionDto;
import org.springframework.stereotype.Service;

@Named(value="isis.ext.executionOutbox.ExecutionOutboxEntry")
@DomainObject(editing=Editing.DISABLED, entityChangePublishing=Publishing.DISABLED)
@DomainObjectLayout(titleUiEvent=TitleUiEvent.class, iconUiEvent=IconUiEvent.class, cssClassUiEvent=CssClassUiEvent.class, layoutUiEvent=LayoutUiEvent.class)
public abstract class ExecutionOutboxEntry
implements Comparable<ExecutionOutboxEntry>,
DomainChangeRecord,
HasInteractionIdAndSequence,
HasInteractionDto {
    public static final String LOGICAL_TYPE_NAME = "isis.ext.executionOutbox.ExecutionOutboxEntry";
    public static final String SCHEMA = "isisExtExecutionOutbox";
    public static final String TABLE = "ExecutionOutboxEntry";
    @Inject
    BookmarkService bookmarkService;
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    static final ToString<ExecutionOutboxEntry> stringifier = ObjectContracts.toString((String)"interactionId", ExecutionOutboxEntry::getInteractionId).thenToString("sequence", ExecutionOutboxEntry::getSequence).thenToString("username", ExecutionOutboxEntry::getUsername).thenToString("type", ExecutionOutboxEntry::getExecutionType).thenToString("timestamp", ExecutionOutboxEntry::getTimestamp).thenToString("target", ExecutionOutboxEntry::getTarget).thenToString("logicalMemberIdentifier", ExecutionOutboxEntry::getLogicalMemberIdentifier).thenToStringOmitIfAbsent("startedAt", ExecutionOutboxEntry::getStartedAt).thenToStringOmitIfAbsent("completedAt", ExecutionOutboxEntry::getCompletedAt);

    public ExecutionOutboxEntry(@NonNull Execution<? extends MemberExecutionDto, ?> execution) {
        if (execution == null) {
            throw new NullPointerException("execution is marked non-null but is null");
        }
        this.init(execution);
    }

    @Programmatic
    public void init(Execution<? extends MemberExecutionDto, ?> execution) {
        UUID interactionId = execution.getInteraction().getInteractionId();
        this.setInteractionId(interactionId);
        MemberExecutionDto memberExecutionDto = execution.getDto();
        this.setSequence(memberExecutionDto.getSequence());
        InteractionDto interactionDto = new InteractionDto();
        interactionDto.setInteractionId(interactionId.toString());
        interactionDto.setExecution(memberExecutionDto);
        this.setInteractionDto(interactionDto);
        this.setTimestamp(execution.getStartedAt());
        this.setStartedAt(execution.getStartedAt());
        this.setCompletedAt(execution.getCompletedAt());
        this.setLogicalMemberIdentifier(memberExecutionDto.getLogicalMemberIdentifier());
        this.setTarget(Bookmark.forOidDto((OidDto)memberExecutionDto.getTarget()));
        this.setUsername(memberExecutionDto.getUsername());
        if (execution instanceof PropertyEdit) {
            this.setExecutionType(ExecutionOutboxEntryType.PROPERTY_EDIT);
        } else if (execution instanceof ActionInvocation) {
            this.setExecutionType(ExecutionOutboxEntryType.ACTION_INVOCATION);
        } else {
            throw new IllegalArgumentException(String.format("Execution subtype unknown: %s", execution.getClass().getName()));
        }
    }

    @ObjectSupport
    public String title() {
        return new TitleBuffer().append(formatter.format(this.getTimestamp().toLocalDateTime())).append(" ").append(this.getLogicalMemberIdentifier()).toString();
    }

    @DomainChangeRecord.Type
    public DomainChangeRecord.ChangeType getType() {
        return DomainChangeRecord.ChangeType.EXECUTION;
    }

    @InteractionId
    public abstract UUID getInteractionId();

    public abstract void setInteractionId(UUID var1);

    @Sequence
    public abstract int getSequence();

    public abstract void setSequence(int var1);

    @ExecutionType
    public abstract ExecutionOutboxEntryType getExecutionType();

    public abstract void setExecutionType(ExecutionOutboxEntryType var1);

    @Username
    public abstract String getUsername();

    public abstract void setUsername(String var1);

    @Timestamp
    public abstract java.sql.Timestamp getTimestamp();

    public abstract void setTimestamp(java.sql.Timestamp var1);

    @Target
    public abstract Bookmark getTarget();

    public abstract void setTarget(Bookmark var1);

    @LogicalMemberIdentifier
    public abstract String getLogicalMemberIdentifier();

    public abstract void setLogicalMemberIdentifier(String var1);

    @InteractionDtoAnnot
    public abstract InteractionDto getInteractionDto();

    public abstract void setInteractionDto(InteractionDto var1);

    @StartedAt
    public abstract java.sql.Timestamp getStartedAt();

    public abstract void setStartedAt(java.sql.Timestamp var1);

    @CompletedAt
    public abstract java.sql.Timestamp getCompletedAt();

    public abstract void setCompletedAt(java.sql.Timestamp var1);

    @Duration
    public BigDecimal getDuration() {
        return _Temporals.secondsBetweenAsDecimal((java.sql.Timestamp)this.getStartedAt(), (java.sql.Timestamp)this.getCompletedAt()).orElse(null);
    }

    @Override
    public int compareTo(ExecutionOutboxEntry other) {
        return this.getTimestamp().compareTo(other.getTimestamp());
    }

    public String toString() {
        return stringifier.toString((Object)this);
    }

    public ExecutionOutboxEntry() {
    }

    @Service
    @Priority(value=0x5FFFFFF5)
    public static class TableColumnOrderDefault
    extends TableColumnOrderForCollectionTypeAbstract<ExecutionOutboxEntry> {
        public TableColumnOrderDefault() {
            super(ExecutionOutboxEntry.class);
        }

        protected List<String> orderParented(Object parent, String collectionId, List<String> propertyIds) {
            return this.ordered(propertyIds);
        }

        protected List<String> orderStandalone(List<String> propertyIds) {
            return this.ordered(propertyIds);
        }

        private List<String> ordered(List<String> propertyIds) {
            return Arrays.asList("timestamp", "target", "logicalMemberIdentifier", "username", "duration", "interactionId", "sequence");
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @Digits(integer=5, fraction=3)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Duration {
        public static final int DIGITS_INTEGER = 5;
        public static final int DIGITS_FRACTION = 3;

        public static class DomainEvent
        extends PropertyDomainEvent<BigDecimal> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, optionality=Optionality.OPTIONAL)
    @Parameter(optionality=Optionality.OPTIONAL)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CompletedAt {
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<java.sql.Timestamp> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, optionality=Optionality.OPTIONAL)
    @Parameter(optionality=Optionality.OPTIONAL)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface StartedAt {
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<java.sql.Timestamp> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @HasInteractionDto.InteractionDtoAnnot
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface InteractionDtoAnnot {
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<InteractionDto> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(hidden=Where.ALL_TABLES)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface LogicalMemberIdentifier {
        public static final int MAX_LENGTH = 255;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @DomainChangeRecord.Target
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Target {
        public static final int MAX_LENGTH = 1500;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<Bookmark> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @DomainChangeRecord.Timestamp
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Timestamp {
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<java.sql.Timestamp> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @DomainChangeRecord.Username
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Username {
        public static final int MAX_LENGTH = 120;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ExecutionType {
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";
        public static final int MAX_LENGTH = 30;

        public static class DomainEvent
        extends PropertyDomainEvent<ExecutionOutboxEntryType> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @HasInteractionIdAndSequence.Sequence
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Sequence {
        public static final String NAME = "sequence";
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<Integer> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @DomainChangeRecord.InteractionId
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface InteractionId {
        public static final int MAX_LENGTH = 36;
        public static final String NAME = "interactionId";
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<UUID> {
        }
    }

    protected static final class Util {
        public static String abbreviated(String str, int maxLength) {
            return str != null ? (str.length() < maxLength ? str : str.substring(0, maxLength - 3) + "...") : null;
        }

        private Util() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class Nq {
        public static final String FIND_BY_INTERACTION_ID_AND_SEQUENCE = "isis.ext.executionOutbox.ExecutionOutboxEntry.findByInteractionIdAndSequence";
        public static final String FIND_OLDEST = "isis.ext.executionOutbox.ExecutionOutboxEntry.findOldest";

        private Nq() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static abstract class ActionDomainEvent
    extends IsisModuleExtExecutionOutboxApplib.ActionDomainEvent<ExecutionOutboxEntry> {
    }

    public static abstract class CollectionDomainEvent<T>
    extends IsisModuleExtExecutionOutboxApplib.CollectionDomainEvent<ExecutionOutboxEntry, T> {
    }

    public static abstract class PropertyDomainEvent<T>
    extends IsisModuleExtExecutionOutboxApplib.PropertyDomainEvent<ExecutionOutboxEntry, T> {
    }

    public static class LayoutUiEvent
    extends IsisModuleExtExecutionOutboxApplib.LayoutUiEvent<ExecutionOutboxEntry> {
    }

    public static class CssClassUiEvent
    extends IsisModuleExtExecutionOutboxApplib.CssClassUiEvent<ExecutionOutboxEntry> {
    }

    public static class IconUiEvent
    extends IsisModuleExtExecutionOutboxApplib.IconUiEvent<ExecutionOutboxEntry> {
    }

    public static class TitleUiEvent
    extends IsisModuleExtExecutionOutboxApplib.TitleUiEvent<ExecutionOutboxEntry> {
    }
}

