/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.executionoutbox.applib.app;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.clock.ClockService;
import org.apache.isis.extensions.executionoutbox.applib.IsisModuleExtExecutionOutboxApplib;
import org.apache.isis.extensions.executionoutbox.applib.dom.ExecutionOutboxEntry;
import org.apache.isis.extensions.executionoutbox.applib.dom.ExecutionOutboxEntryRepository;

@Named(value="isis.ext.executionOutbox.ExecutionOutboxMenu")
@DomainService(nature=NatureOfService.VIEW)
@DomainServiceLayout(named="Activity", menuBar=DomainServiceLayout.MenuBar.SECONDARY)
@Priority(value=0x1FFFFFFF)
public class ExecutionOutboxMenu {
    public static final String LOGICAL_TYPE_NAME = "isis.ext.executionOutbox.ExecutionOutboxMenu";
    final ExecutionOutboxEntryRepository<? extends ExecutionOutboxEntry> executionOutboxEntryRepository;
    final ClockService clockService;

    @Action(semantics=SemanticsOf.SAFE)
    @ActionLayout(describedAs="Returns to oldest 100 entries (next to be processed) in the outbox")
    public List<? extends ExecutionOutboxEntry> findOldest() {
        return this.executionOutboxEntryRepository.findOldest();
    }

    @Action(semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(describedAs="Returns all entries (still to be processed) in the outbox")
    public List<? extends ExecutionOutboxEntry> findAll() {
        return this.executionOutboxEntryRepository.findAll();
    }

    private LocalDate now() {
        return this.clockService.getClock().nowAsLocalDate(ZoneId.systemDefault());
    }

    @Inject
    public ExecutionOutboxMenu(ExecutionOutboxEntryRepository<? extends ExecutionOutboxEntry> executionOutboxEntryRepository, ClockService clockService) {
        this.executionOutboxEntryRepository = executionOutboxEntryRepository;
        this.clockService = clockService;
    }

    public static abstract class ActionDomainEvent
    extends IsisModuleExtExecutionOutboxApplib.ActionDomainEvent<ExecutionOutboxMenu> {
    }
}

