/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.executionlog.jdo.dom;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.UUID;
import javax.annotation.Priority;
import lombok.NonNull;
import org.apache.isis.applib.value.semantics.ValueSemanticsBasedOnIdStringifierEntityAgnostic;
import org.springframework.stereotype.Component;

public class ExecutionLogEntryPK
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR = "_";
    public UUID interactionId;
    public int sequence;

    public ExecutionLogEntryPK(String value) {
        StringTokenizer token = new StringTokenizer(value, SEPARATOR);
        this.interactionId = UUID.fromString(token.nextToken());
        this.sequence = Integer.parseInt(token.nextToken());
    }

    public String toString() {
        return this.interactionId + SEPARATOR + this.sequence;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionLogEntryPK)) {
            return false;
        }
        ExecutionLogEntryPK other = (ExecutionLogEntryPK)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSequence() != other.getSequence()) {
            return false;
        }
        UUID this$interactionId = this.getInteractionId();
        UUID other$interactionId = other.getInteractionId();
        return !(this$interactionId == null ? other$interactionId != null : !((Object)this$interactionId).equals(other$interactionId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExecutionLogEntryPK;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSequence();
        UUID $interactionId = this.getInteractionId();
        result = result * 59 + ($interactionId == null ? 43 : ((Object)$interactionId).hashCode());
        return result;
    }

    public ExecutionLogEntryPK() {
    }

    public UUID getInteractionId() {
        return this.interactionId;
    }

    public void setInteractionId(UUID interactionId) {
        this.interactionId = interactionId;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    @Component
    @Priority(value=0x3FFFFFFF)
    public static class Semantics
    extends ValueSemanticsBasedOnIdStringifierEntityAgnostic<ExecutionLogEntryPK> {
        public Semantics() {
            super(ExecutionLogEntryPK.class);
        }

        public ExecutionLogEntryPK destring(@NonNull String stringified) {
            if (stringified == null) {
                throw new NullPointerException("stringified is marked non-null but is null");
            }
            return new ExecutionLogEntryPK(stringified);
        }
    }
}

