/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.excel.integtests.tests;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.commons.internal.base._Bytes;
import org.apache.isis.commons.internal.resources._Resources;
import org.apache.isis.extensions.excel.fixtures.demoapp.demomodule.dom.bulkupdate.BulkUpdateLineItemForDemoToDoItem;
import org.apache.isis.extensions.excel.fixtures.demoapp.demomodule.dom.bulkupdate.BulkUpdateManagerForDemoToDoItem;
import org.apache.isis.extensions.excel.fixtures.demoapp.demomodule.dom.bulkupdate.BulkUpdateMenuForDemoToDoItem;
import org.apache.isis.extensions.excel.fixtures.demoapp.demomodule.fixturescripts.DemoToDoItem_recreate_usingExcelFixture;
import org.apache.isis.extensions.excel.fixtures.demoapp.todomodule.dom.ExcelDemoToDoItemMenu;
import org.apache.isis.extensions.excel.integtests.ExcelModuleIntegTestAbstract;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureScript;
import org.assertj.core.api.Assertions;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;

public class ExcelModuleDemoToDoItemBulkUpdateManager_IntegTest
extends ExcelModuleIntegTestAbstract {
    @Inject
    private ExcelDemoToDoItemMenu toDoItems;
    @Inject
    private BulkUpdateMenuForDemoToDoItem exportImportService;
    private BulkUpdateManagerForDemoToDoItem bulkUpdateManager;

    @BeforeEach
    public void setUpData() throws Exception {
        this.fixtureScripts.run(new FixtureScript[]{new DemoToDoItem_recreate_usingExcelFixture()});
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.bulkUpdateManager = this.exportImportService.bulkUpdateManager();
    }

    @Disabled(value="TODO - reinstate")
    public void export_then_import() throws Exception {
        byte[] expectedBytes = ExcelModuleDemoToDoItemBulkUpdateManager_IntegTest.getBytes(((Object)((Object)this)).getClass(), "toDoItems-expected.xlsx");
        Blob exportedBlob = this.bulkUpdateManager.export();
        byte[] actualBytes = exportedBlob.getBytes();
        byte[] updatedBytes = ExcelModuleDemoToDoItemBulkUpdateManager_IntegTest.getBytes(((Object)((Object)this)).getClass(), "toDoItems-updated.xlsx");
        List lineItems = this.bulkUpdateManager.importBlob(new Blob("toDoItems-updated.xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", updatedBytes));
        Assertions.assertThat((int)lineItems.size()).isEqualTo(2);
        BulkUpdateLineItemForDemoToDoItem lineItem1 = (BulkUpdateLineItemForDemoToDoItem)lineItems.get(0);
        BulkUpdateLineItemForDemoToDoItem lineItem2 = (BulkUpdateLineItemForDemoToDoItem)lineItems.get(1);
        Assertions.assertThat((String)lineItem1.getDescription()).isEqualTo("Buy milk - updated!");
        Assertions.assertThat((String)lineItem2.getNotes()).isEqualTo("Get sliced brown if possible.");
    }

    private static byte[] getBytes(Class<?> contextClass, String resourceName) throws IOException {
        return _Bytes.of((InputStream)_Resources.load(contextClass, (String)resourceName));
    }

    private static final Matcher<? super byte[]> lengthWithinPercentage(final byte[] expectedBytes, final int percentage) {
        return new TypeSafeMatcher<byte[]>(){

            protected boolean matchesSafely(byte[] item) {
                double lower = expectedBytes.length * (100 - percentage) / 100;
                double upper = expectedBytes.length * (100 + percentage) / 100;
                int actualLength = item.length;
                return (double)actualLength > lower && (double)actualLength < upper;
            }

            public void describeTo(Description description) {
                description.appendText("Byte array with length within " + percentage + "% of expected length (" + expectedBytes.length + " bytes)");
            }
        };
    }
}

