/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.commandreplay.secondary.ui;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.extensions.commandlog.impl.jdo.CommandJdo;
import org.apache.isis.extensions.commandlog.impl.jdo.CommandJdoRepository;
import org.apache.isis.extensions.commandreplay.secondary.IsisModuleExtCommandReplaySecondary;
import org.apache.isis.schema.cmd.v2.CommandDto;
import org.apache.isis.schema.cmd.v2.CommandsDto;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.annotation.Order;

@DomainService(nature=NatureOfService.VIEW, objectType="isis.ext.commandReplaySecondary.CommandReplayOnSecondaryService")
@DomainServiceLayout(named="Activity", menuBar=DomainServiceLayout.MenuBar.SECONDARY)
@Named(value="isis.ext.commandReplaySecondary.CommandReplayOnSecondaryService")
@Order(value=0)
public class CommandReplayOnSecondaryService {
    private static final Logger log = LogManager.getLogger(CommandReplayOnSecondaryService.class);
    @Inject
    final CommandJdoRepository commandJdoRepository;
    @Inject
    final JaxbService jaxbService;

    @Action(domainEvent=FindMostRecentReplayedDomainEvent.class, semantics=SemanticsOf.SAFE)
    @ActionLayout(cssClassFa="fa-bath")
    @MemberOrder(sequence="60.1")
    public CommandJdo findMostRecentReplayed() {
        return this.commandJdoRepository.findMostRecentReplayed().orElse(null);
    }

    @Action(domainEvent=UploadCommandsDomainEvent.class, semantics=SemanticsOf.NON_IDEMPOTENT)
    @ActionLayout(cssClassFa="fa-upload")
    @MemberOrder(sequence="60.2")
    public void uploadCommands(Clob commandsDtoAsXml) {
        List<CommandDto> commandDtoList;
        CharSequence chars = commandsDtoAsXml.getChars();
        try {
            CommandsDto commandsDto = (CommandsDto)this.jaxbService.fromXml(CommandsDto.class, chars.toString());
            commandDtoList = commandsDto.getCommandDto();
        }
        catch (Exception ex) {
            CommandDto commandDto = (CommandDto)this.jaxbService.fromXml(CommandDto.class, chars.toString());
            commandDtoList = Collections.singletonList(commandDto);
        }
        for (CommandDto commandDto : commandDtoList) {
            this.commandJdoRepository.saveForReplay(commandDto);
        }
    }

    public CommandReplayOnSecondaryService(CommandJdoRepository commandJdoRepository, JaxbService jaxbService) {
        this.commandJdoRepository = commandJdoRepository;
        this.jaxbService = jaxbService;
    }

    public static class UploadCommandsDomainEvent
    extends ActionDomainEvent {
    }

    public static class FindMostRecentReplayedDomainEvent
    extends ActionDomainEvent {
    }

    public static abstract class ActionDomainEvent
    extends IsisModuleExtCommandReplaySecondary.ActionDomainEvent<CommandReplayOnSecondaryService> {
    }
}

