/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.commandreplay.secondary.mixins;

import java.util.Optional;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.extensions.commandlog.impl.IsisModuleExtCommandLogImpl;
import org.apache.isis.extensions.commandlog.impl.jdo.CommandJdo;
import org.apache.isis.extensions.commandlog.impl.jdo.ReplayState;
import org.apache.isis.extensions.commandreplay.secondary.config.SecondaryConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Action(semantics=SemanticsOf.NON_IDEMPOTENT_ARE_YOU_SURE, domainEvent=ActionDomainEvent.class)
public class CommandJdo_exclude {
    private static final Logger log = LogManager.getLogger(CommandJdo_exclude.class);
    final CommandJdo commandJdo;
    @Inject
    Optional<SecondaryConfig> secondaryConfig;

    @MemberOrder(name="executeIn", sequence="2")
    public CommandJdo act() {
        this.commandJdo.setReplayState(ReplayState.EXCLUDED);
        return this.commandJdo;
    }

    public boolean hideAct() {
        return !this.secondaryConfig.isPresent() || !this.secondaryConfig.get().isConfigured();
    }

    public String disableAct() {
        boolean notInError = this.commandJdo.getReplayState() == null || !this.commandJdo.getReplayState().isFailed();
        return notInError ? "This command is not in error, so cannot be excluded." : null;
    }

    public CommandJdo_exclude(CommandJdo commandJdo) {
        this.commandJdo = commandJdo;
    }

    public static class ActionDomainEvent
    extends IsisModuleExtCommandLogImpl.ActionDomainEvent<CommandJdo_exclude> {
    }
}

