/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.commandreplay.secondary.jobcallables;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.isis.applib.services.command.CommandExecutorService;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.extensions.commandlog.impl.jdo.CommandJdo;
import org.apache.isis.extensions.commandlog.impl.jdo.CommandJdoRepository;
import org.apache.isis.extensions.commandlog.impl.jdo.ReplayState;
import org.apache.isis.extensions.commandreplay.secondary.SecondaryStatus;
import org.apache.isis.extensions.commandreplay.secondary.StatusException;
import org.apache.isis.extensions.commandreplay.secondary.analysis.CommandReplayAnalysisService;
import org.apache.isis.extensions.commandreplay.secondary.fetch.CommandFetcher;
import org.apache.isis.extensions.commandreplay.secondary.spi.ReplayCommandExecutionController;
import org.apache.isis.schema.cmd.v2.CommandDto;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicateAndRunCommands
implements Callable<SecondaryStatus> {
    private static final Logger log = LogManager.getLogger(ReplicateAndRunCommands.class);
    @Inject
    CommandExecutorService commandExecutorService;
    @Inject
    TransactionService transactionService;
    @Inject
    CommandFetcher commandFetcher;
    @Inject
    CommandJdoRepository commandJdoRepository;
    @Inject
    CommandReplayAnalysisService analysisService;
    @Inject
    Optional<ReplayCommandExecutionController> controller;

    @Override
    public SecondaryStatus call() {
        try {
            this.doCall();
            return SecondaryStatus.OK;
        }
        catch (StatusException e) {
            return e.secondaryStatus;
        }
    }

    private void doCall() throws StatusException {
        if (!this.isRunning()) {
            log.debug("ReplicateAndRunCommands is paused");
            return;
        }
        while (this.isRunning()) {
            List commandsToReplay = this.commandJdoRepository.findNotYetReplayed();
            if (commandsToReplay.isEmpty()) {
                List<CommandDto> commandDtos;
                CommandJdo hwm = this.commandJdoRepository.findMostRecentReplayed().orElse(null);
                if (hwm != null) {
                    if (hwm.getReplayState() != null && hwm.getReplayState().isFailed()) {
                        log.info("Command {} hit replay error", (Object)hwm.getInteractionId());
                        return;
                    }
                } else {
                    hwm = this.commandJdoRepository.findMostRecentCompleted().orElse(null);
                }
                if ((commandsToReplay = (commandDtos = this.commandFetcher.fetchCommand(hwm)).stream().map(dto -> this.transactionService.callWithinCurrentTransactionElseCreateNew(() -> this.commandJdoRepository.saveForReplay(dto)).optionalElseFail().orElse(null)).collect(Collectors.toList())).isEmpty()) {
                    return;
                }
            }
            this.replay(commandsToReplay);
        }
    }

    private void replay(List<CommandJdo> commandsToReplay) {
        commandsToReplay.forEach(commandJdo -> {
            log.info("replaying {}", (Object)commandJdo.getInteractionId());
            ReplayState replayState = this.executeCommandInTranAndAnalyse((CommandJdo)commandJdo);
            if (replayState.isFailed()) {
                return;
            }
            CommandJdo parent = commandJdo;
            List childCommands = this.transactionService.callWithinCurrentTransactionElseCreateNew(() -> this.commandJdoRepository.findByParent(parent)).optionalElseFail().orElse(null);
            for (CommandJdo childCommand : childCommands) {
                ReplayState childReplayState = this.executeCommandInTranAndAnalyse(childCommand);
                if (!childReplayState.isFailed()) continue;
                return;
            }
        });
    }

    private ReplayState executeCommandInTranAndAnalyse(CommandJdo commandJdo) {
        this.transactionService.runWithinCurrentTransactionElseCreateNew(() -> this.commandExecutorService.executeCommand(CommandExecutorService.SudoPolicy.SWITCH, commandJdo.getCommandDto(), commandJdo.outcomeHandler()));
        this.transactionService.runWithinCurrentTransactionElseCreateNew(() -> this.analysisService.analyse(commandJdo));
        return commandJdo.getReplayState();
    }

    private boolean isRunning() {
        return this.controller.map(control -> this.transactionService.callWithinCurrentTransactionElseCreateNew(control::getState).optionalElseFail().orElse(null)).map(state -> state == ReplayCommandExecutionController.State.RUNNING).orElse(true);
    }
}

