/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.commandreplay.secondary.job;

import org.apache.isis.extensions.commandreplay.secondary.SecondaryStatus;
import org.apache.isis.extensions.quartz.context.JobExecutionData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionContext;

class SecondaryStatusData {
    private static final Logger log = LogManager.getLogger(SecondaryStatusData.class);
    private static final String KEY_SECONDARY_STATUS = SecondaryStatusData.class.getCanonicalName();
    private final JobExecutionData jobExecutionData;

    SecondaryStatusData(JobExecutionContext jobExecutionContext) {
        this.jobExecutionData = new JobExecutionData(jobExecutionContext);
    }

    SecondaryStatus getSecondaryStatus() {
        return this.getSecondaryStatus(SecondaryStatus.UNKNOWN_STATE);
    }

    SecondaryStatus getSecondaryStatus(SecondaryStatus defaultStatus) {
        String mode = this.jobExecutionData.getString(KEY_SECONDARY_STATUS, defaultStatus.name());
        return SecondaryStatus.valueOf(mode);
    }

    void setSecondaryStatus(SecondaryStatus mode) {
        this.jobExecutionData.setString(KEY_SECONDARY_STATUS, mode.name());
    }
}

