/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.commandreplay.secondary.job;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.isis.applib.services.user.UserMemento;
import org.apache.isis.core.interaction.session.InteractionFactory;
import org.apache.isis.core.security.authentication.Authentication;
import org.apache.isis.core.security.authentication.standard.SimpleAuthentication;
import org.apache.isis.extensions.commandreplay.secondary.SecondaryStatus;
import org.apache.isis.extensions.commandreplay.secondary.config.SecondaryConfig;
import org.apache.isis.extensions.commandreplay.secondary.job.SecondaryStatusData;
import org.apache.isis.extensions.commandreplay.secondary.jobcallables.IsTickingClockInitialized;
import org.apache.isis.extensions.commandreplay.secondary.jobcallables.ReplicateAndRunCommands;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.PersistJobDataAfterExecution;

@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class ReplicateAndReplayJob
implements Job {
    private static final Logger log = LogManager.getLogger(ReplicateAndReplayJob.class);
    @Inject
    SecondaryConfig secondaryConfig;
    Authentication authentication;
    @Inject
    protected InteractionFactory isisInteractionFactory;

    public void execute(JobExecutionContext quartzContext) {
        new SecondaryStatusData(quartzContext);
        if (this.secondaryConfig.isConfigured()) {
            UserMemento user = UserMemento.ofNameAndRoleNames((String)this.secondaryConfig.getPrimaryUser(), this.secondaryConfig.getQuartzRoles().stream());
            this.authentication = SimpleAuthentication.validOf((UserMemento)user);
            this.exec(quartzContext);
        }
    }

    private void exec(JobExecutionContext quartzContext) {
        SecondaryStatusData ssh = new SecondaryStatusData(quartzContext);
        SecondaryStatus secondaryStatus = ssh.getSecondaryStatus(SecondaryStatus.TICKING_CLOCK_STATUS_UNKNOWN);
        switch (secondaryStatus) {
            case TICKING_CLOCK_STATUS_UNKNOWN: 
            case TICKING_CLOCK_NOT_YET_INITIALIZED: {
                ssh.setSecondaryStatus(this.isTickingClockInitialized(this.authentication) ? SecondaryStatus.OK : SecondaryStatus.TICKING_CLOCK_NOT_YET_INITIALIZED);
                if (ssh.getSecondaryStatus() == SecondaryStatus.OK) {
                    log.info("Ticking clock now initialised");
                } else {
                    log.info("Still waiting for ticking clock to be initialised: {}", (Object)secondaryStatus);
                }
                return;
            }
            case OK: {
                SecondaryStatus newStatus = (SecondaryStatus)((Object)this.isisInteractionFactory.callAuthenticated(this.authentication, (Callable)new ReplicateAndRunCommands()));
                if (newStatus != null) {
                    ssh.setSecondaryStatus(newStatus);
                }
                return;
            }
            case REST_CALL_FAILING: 
            case FAILED_TO_UNMARSHALL_RESPONSE: 
            case UNKNOWN_STATE: {
                log.warn("skipped - configured as secondary, however: {}", (Object)secondaryStatus);
                return;
            }
        }
        throw new IllegalStateException("Unrecognised status: " + (Object)((Object)secondaryStatus));
    }

    private boolean isTickingClockInitialized(Authentication authentication) {
        return (Boolean)this.isisInteractionFactory.callAuthenticated(authentication, (Callable)new IsTickingClockInitialized());
    }
}

