/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.commandreplay.secondary.fetch;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.extensions.commandlog.impl.jdo.CommandJdo;
import org.apache.isis.extensions.commandreplay.secondary.SecondaryStatus;
import org.apache.isis.extensions.commandreplay.secondary.StatusException;
import org.apache.isis.extensions.commandreplay.secondary.config.SecondaryConfig;
import org.apache.isis.extensions.jaxrsclient.applib.client.JaxRsClient;
import org.apache.isis.extensions.jaxrsclient.applib.client.JaxRsResponse;
import org.apache.isis.extensions.jaxrsclient.impl.client.JaxRsClientDefault;
import org.apache.isis.schema.cmd.v2.CommandDto;
import org.apache.isis.schema.cmd.v2.CommandsDto;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.ext.commandReplaySecondary.CommandFetcher")
@Order(value=0)
public class CommandFetcher {
    private static final Logger log = LogManager.getLogger(CommandFetcher.class);
    static final String URL_SUFFIX = "services/isisExtensionsCommandReplayPrimary.CommandRetrievalService/actions/findCommandsOnPrimaryFrom/invoke";
    @Inject
    SecondaryConfig secondaryConfig;

    public List<CommandDto> fetchCommand(@Nullable CommandJdo previousHwmIfAny) throws StatusException {
        log.debug("finding command on primary ...");
        CommandsDto commandsDto = this.fetchCommands(previousHwmIfAny);
        return commandsDto != null ? commandsDto.getCommandDto() : Collections.emptyList();
    }

    private CommandsDto fetchCommands(CommandJdo previousHwmIfAny) throws StatusException {
        UUID transactionId = previousHwmIfAny != null ? previousHwmIfAny.getInteractionId() : null;
        log.debug("finding commands on primary ...");
        URI uri = this.buildUri(transactionId);
        JaxRsResponse response = this.callPrimary(uri);
        CommandsDto commandsDto = this.unmarshal(response, uri);
        int size = commandsDto.getCommandDto().size();
        if (size == 0) {
            return null;
        }
        return commandsDto;
    }

    private URI buildUri(UUID interactionId) {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(interactionId != null ? String.format("%s%s?interactionId=%s&batchSize=%d", this.secondaryConfig.getPrimaryBaseUrlRestful(), URL_SUFFIX, interactionId, this.secondaryConfig.getBatchSize()) : String.format("%s%s?batchSize=%d", this.secondaryConfig.getPrimaryBaseUrlRestful(), URL_SUFFIX, this.secondaryConfig.getBatchSize())));
        URI uri = uriBuilder.build(new Object[0]);
        log.info("uri = {}", (Object)uri);
        return uri;
    }

    private JaxRsResponse callPrimary(URI uri) throws StatusException {
        JaxRsResponse response;
        JaxRsClientDefault jaxRsClient = new JaxRsClientDefault();
        try {
            String user = this.secondaryConfig.getPrimaryUser();
            String password = this.secondaryConfig.getPrimaryPassword();
            response = jaxRsClient.get(uri, CommandsDto.class, JaxRsClient.ReprType.ACTION_RESULT, user, password);
            int status = response.getStatus();
            if (status != Response.Status.OK.getStatusCode()) {
                String entity = CommandFetcher.readEntityFrom(response);
                if (entity != null) {
                    log.warn("status: {}, entity: \n{}", (Object)status, (Object)entity);
                } else {
                    log.warn("status: {}, unable to read entity from response", (Object)status);
                }
                throw new StatusException(SecondaryStatus.REST_CALL_FAILING);
            }
        }
        catch (Exception ex) {
            log.warn("rest call failed", (Throwable)ex);
            throw new StatusException(SecondaryStatus.REST_CALL_FAILING, ex);
        }
        return response;
    }

    private CommandsDto unmarshal(JaxRsResponse response, URI uri) throws StatusException {
        CommandsDto commandsDto;
        String entity = "<unable to read from response entity>";
        try {
            entity = CommandFetcher.readEntityFrom(response);
            JaxbService.Simple jaxbService = new JaxbService.Simple();
            commandsDto = (CommandsDto)jaxbService.fromXml(CommandsDto.class, entity);
            log.debug("commands:\n{}", (Object)entity);
        }
        catch (Exception ex) {
            log.warn("unable to unmarshal entity from {} to CommandsDto.class; was:\n{}", (Object)uri, (Object)entity);
            throw new StatusException(SecondaryStatus.FAILED_TO_UNMARSHALL_RESPONSE, ex);
        }
        return commandsDto;
    }

    private static String readEntityFrom(JaxRsResponse response) {
        try {
            return (String)response.readEntity(String.class);
        }
        catch (Exception e) {
            return null;
        }
    }
}

