/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.commandreplay.secondary.executor;

import java.util.function.Supplier;
import javax.inject.Named;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.isis.applib.jaxb.JavaSqlXMLGregorianCalendarMarshalling;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandExecutorService;
import org.apache.isis.applib.services.command.CommandOutcomeHandler;
import org.apache.isis.extensions.commandreplay.secondary.clock.TickingClockService;
import org.apache.isis.schema.cmd.v2.CommandDto;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.ext.commandReplaySecondary.CommandExecutorServiceWithTime")
@Order(value=-10)
@Qualifier(value="WithTime")
public class CommandExecutorServiceWithTime
implements CommandExecutorService {
    private static final Logger log = LogManager.getLogger(CommandExecutorServiceWithTime.class);
    final CommandExecutorService delegate;
    final TickingClockService tickingClockService;

    public CommandExecutorServiceWithTime(@Qualifier(value="Default") CommandExecutorService delegate, TickingClockService tickingClockService) {
        this.delegate = delegate;
        this.tickingClockService = tickingClockService;
    }

    public Bookmark executeCommand(Command command) {
        Supplier<Bookmark> executeCommand = () -> this.delegate.executeCommand(command);
        return this.tickingClockService.isInitialized() ? this.tickingClockService.at(command.getTimestamp(), executeCommand) : executeCommand.get();
    }

    public Bookmark executeCommand(CommandExecutorService.SudoPolicy sudoPolicy, Command command) {
        Supplier<Bookmark> executeCommand = () -> this.delegate.executeCommand(sudoPolicy, command);
        return this.tickingClockService.isInitialized() ? this.tickingClockService.at(command.getTimestamp(), executeCommand) : executeCommand.get();
    }

    public Bookmark executeCommand(CommandDto dto, CommandOutcomeHandler outcomeHandler) {
        Supplier<Bookmark> executeCommand = () -> this.delegate.executeCommand(dto, outcomeHandler);
        return this.tickingClockService.isInitialized() ? this.tickingClockService.at(JavaSqlXMLGregorianCalendarMarshalling.toTimestamp((XMLGregorianCalendar)dto.getTimestamp()), executeCommand) : executeCommand.get();
    }

    public Bookmark executeCommand(CommandExecutorService.SudoPolicy sudoPolicy, CommandDto dto, CommandOutcomeHandler outcomeHandler) {
        Supplier<Bookmark> executeCommand = () -> this.delegate.executeCommand(sudoPolicy, dto, outcomeHandler);
        return this.tickingClockService.isInitialized() ? this.tickingClockService.at(JavaSqlXMLGregorianCalendarMarshalling.toTimestamp((XMLGregorianCalendar)dto.getTimestamp()), executeCommand) : executeCommand.get();
    }
}

