/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.commandreplay.secondary.config;

import java.util.List;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import org.apache.isis.core.config.IsisConfiguration;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.ext.commandReplaySecondary.SecondaryConfig")
@Order(value=0)
public class SecondaryConfig {
    final String primaryUser;
    final String primaryPassword;
    final String primaryBaseUrlRestful;
    final String primaryBaseUrlWicket;
    final int batchSize;
    final String quartzUser;
    final List<String> quartzRoles;

    public SecondaryConfig(@NotNull IsisConfiguration isisConfiguration) {
        IsisConfiguration.Extensions.CommandReplay config = isisConfiguration.getExtensions().getCommandReplay();
        IsisConfiguration.Extensions.CommandReplay.PrimaryAccess primaryAccess = config.getPrimaryAccess();
        this.primaryUser = primaryAccess.getUser().orElse(null);
        this.primaryPassword = primaryAccess.getPassword().orElse(null);
        this.primaryBaseUrlRestful = primaryAccess.getBaseUrlRestful().orElse(null);
        this.primaryBaseUrlWicket = primaryAccess.getBaseUrlWicket().orElse(null);
        this.batchSize = config.getBatchSize();
        this.quartzUser = config.getQuartzSession().getUser();
        this.quartzRoles = config.getQuartzSession().getRoles();
    }

    public boolean isConfigured() {
        return this.primaryUser != null && this.primaryPassword != null && this.primaryBaseUrlRestful != null && this.quartzUser != null && this.quartzRoles != null;
    }

    public String getPrimaryUser() {
        return this.primaryUser;
    }

    public String getPrimaryPassword() {
        return this.primaryPassword;
    }

    public String getPrimaryBaseUrlRestful() {
        return this.primaryBaseUrlRestful;
    }

    public String getPrimaryBaseUrlWicket() {
        return this.primaryBaseUrlWicket;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String getQuartzUser() {
        return this.quartzUser;
    }

    public List<String> getQuartzRoles() {
        return this.quartzRoles;
    }
}

