/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.commandreplay.secondary.clock;

import java.sql.Timestamp;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.testing.fixtures.applib.clock.Clock;
import org.apache.isis.testing.fixtures.applib.clock.TickingFixtureClock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.ext.commandReplaySecondary.TickingClockService")
@Order(value=0)
public class TickingClockService {
    private static final Logger log = LogManager.getLogger(TickingClockService.class);
    final IsisConfiguration isisConfiguration;

    @PostConstruct
    public void init() {
        Optional baseUrl = this.isisConfiguration.getExtensions().getCommandReplay().getPrimaryAccess().getBaseUrlRestful();
        Optional user = this.isisConfiguration.getExtensions().getCommandReplay().getPrimaryAccess().getUser();
        Optional password = this.isisConfiguration.getExtensions().getCommandReplay().getPrimaryAccess().getPassword();
        if (!(baseUrl.isPresent() && user.isPresent() && password.isPresent())) {
            log.warn("init() - skipping, one or more 'isis.extensions.command-replay.primary' configuration properties has not been set");
            return;
        }
        log.info("init() - replacing existing clock with TickingFixtureClock");
        TickingFixtureClock.replaceExisting();
    }

    public boolean isInitialized() {
        return Clock.getInstance() instanceof TickingFixtureClock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void at(Timestamp timestamp, Runnable runnable) {
        this.ensureInitialized();
        TickingFixtureClock tickingFixtureClock = (TickingFixtureClock)TickingFixtureClock.getInstance();
        long previous = TickingFixtureClock.getEpochMillis();
        long wallTime0 = System.currentTimeMillis();
        try {
            tickingFixtureClock.setTime(timestamp);
            runnable.run();
        }
        finally {
            long wallTime1 = System.currentTimeMillis();
            tickingFixtureClock.setTime(previous + wallTime1 - wallTime0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T at(Timestamp timestamp, Supplier<T> supplier) {
        this.ensureInitialized();
        TickingFixtureClock tickingFixtureClock = (TickingFixtureClock)TickingFixtureClock.getInstance();
        long previous = TickingFixtureClock.getEpochMillis();
        long wallTime0 = System.currentTimeMillis();
        try {
            tickingFixtureClock.setTime(timestamp);
            T t = supplier.get();
            return t;
        }
        finally {
            long wallTime1 = System.currentTimeMillis();
            tickingFixtureClock.setTime(previous + wallTime1 - wallTime0);
        }
    }

    private void ensureInitialized() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Not initialized.  Make sure that the application is configured as a replay secondary by configuring the 'isis.extensions.command-replay.primary' configuration properties.");
        }
    }

    public TickingClockService(IsisConfiguration isisConfiguration) {
        this.isisConfiguration = isisConfiguration;
    }
}

