/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.commandreplay.secondary.analysis;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.extensions.commandlog.impl.jdo.CommandJdo;
import org.apache.isis.extensions.commandreplay.secondary.analyser.CommandReplayAnalyser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.ext.commandReplaySecondary.CommandReplayAnalysisService")
@Order(value=0)
public class CommandReplayAnalysisService {
    private static final Logger log = LogManager.getLogger(CommandReplayAnalysisService.class);
    @Inject
    List<CommandReplayAnalyser> analysers;

    public void analyse(CommandJdo commandJdo) {
        String analysis = this.analyseReplay(commandJdo);
        commandJdo.saveAnalysis(analysis);
    }

    private String analyseReplay(CommandJdo commandJdo) {
        for (CommandReplayAnalyser analyser : this.analysers) {
            try {
                String reason = analyser.analyzeReplay(commandJdo);
                if (reason == null) continue;
                return reason;
            }
            catch (Exception ex) {
                String className = analyser.getClass().getName();
                log.warn("{} threw exception: ", (Object)className, (Object)ex);
                return className + " threw exception: " + ex.getMessage();
            }
        }
        return null;
    }
}

