/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.commandreplay.secondary.analyser;

import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.commanddto.conmap.UserDataKeys;
import org.apache.isis.applib.util.schema.CommandDtoUtils;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.extensions.commandlog.impl.jdo.CommandJdo;
import org.apache.isis.extensions.commandreplay.secondary.analyser.CommandReplayAnalyser;
import org.apache.isis.schema.cmd.v2.CommandDto;
import org.apache.isis.schema.common.v2.InteractionType;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.ext.commandReplaySecondary.CommandReplayAnalyserResult")
@Order(value=0)
public class CommandReplayAnalyserResult
implements CommandReplayAnalyser {
    private final IsisConfiguration isisConfiguration;
    private boolean enabled;

    @PostConstruct
    public void init() {
        this.enabled = this.isisConfiguration.getExtensions().getCommandReplay().getAnalyser().getException().isEnabled();
    }

    @Override
    public String analyzeReplay(CommandJdo commandJdo) {
        if (!this.enabled) {
            return null;
        }
        CommandDto dto = commandJdo.getCommandDto();
        if (dto.getMember().getInteractionType() == InteractionType.PROPERTY_EDIT) {
            return null;
        }
        String primaryResultStr = CommandDtoUtils.getUserData((CommandDto)dto, (String)UserDataKeys.RESULT);
        Bookmark secondaryResult = commandJdo.getResult();
        String secondaryResultStr = secondaryResult != null ? secondaryResult.toString() : null;
        return Objects.equals(primaryResultStr, secondaryResultStr) ? null : String.format("Results differ.  Primary was '%s', secondary is '%s'", primaryResultStr, secondaryResultStr);
    }

    public CommandReplayAnalyserResult(IsisConfiguration isisConfiguration) {
        this.isisConfiguration = isisConfiguration;
    }
}

