/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.commandreplay.secondary.analyser;

import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import org.apache.isis.applib.services.commanddto.conmap.UserDataKeys;
import org.apache.isis.applib.util.schema.CommandDtoUtils;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.extensions.commandlog.impl.jdo.CommandJdo;
import org.apache.isis.extensions.commandreplay.secondary.analyser.CommandReplayAnalyser;
import org.apache.isis.schema.cmd.v2.CommandDto;
import org.apache.isis.schema.common.v2.InteractionType;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.ext.commandReplaySecondary.CommandReplayAnalyserException")
@Order(value=0)
public class CommandReplayAnalyserException
implements CommandReplayAnalyser {
    private final IsisConfiguration isisConfiguration;
    private boolean enabled;

    @PostConstruct
    public void init() {
        this.enabled = this.isisConfiguration.getExtensions().getCommandReplay().getAnalyser().getResult().isEnabled();
    }

    @Override
    public String analyzeReplay(CommandJdo commandJdo) {
        String replayedExceptionTrimmed;
        if (!this.enabled) {
            return null;
        }
        CommandDto dto = commandJdo.getCommandDto();
        if (dto.getMember().getInteractionType() == InteractionType.PROPERTY_EDIT) {
            return null;
        }
        String primaryException = CommandDtoUtils.getUserData((CommandDto)dto, (String)UserDataKeys.EXCEPTION);
        if (_Strings.isNullOrEmpty((CharSequence)primaryException)) {
            return null;
        }
        String replayedException = commandJdo.getException();
        String primaryExceptionTrimmed = this.trimmed(primaryException);
        return Objects.equals(primaryExceptionTrimmed, replayedExceptionTrimmed = this.trimmed(replayedException)) ? null : String.format("Exceptions differ.  On primary system was '%s'", primaryException);
    }

    private String trimmed(String str) {
        return this.withoutWhitespace(this.initialPartOfStackTrace(str));
    }

    private String initialPartOfStackTrace(String str) {
        int toInspectOfStackTrace = 500;
        return str.length() > 500 ? str.substring(0, 500) : str;
    }

    private String withoutWhitespace(String s) {
        return s.replaceAll("\\s", "");
    }

    public CommandReplayAnalyserException(IsisConfiguration isisConfiguration) {
        this.isisConfiguration = isisConfiguration;
    }
}

