/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.commandreplay.secondary;

import javax.inject.Inject;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.extensions.commandlog.impl.IsisModuleExtCommandLogImpl;
import org.apache.isis.extensions.commandreplay.secondary.analyser.CommandReplayAnalyserException;
import org.apache.isis.extensions.commandreplay.secondary.analyser.CommandReplayAnalyserResult;
import org.apache.isis.extensions.commandreplay.secondary.analysis.CommandReplayAnalysisService;
import org.apache.isis.extensions.commandreplay.secondary.clock.TickingClockService;
import org.apache.isis.extensions.commandreplay.secondary.config.SecondaryConfig;
import org.apache.isis.extensions.commandreplay.secondary.executor.CommandExecutorServiceWithTime;
import org.apache.isis.extensions.commandreplay.secondary.fetch.CommandFetcher;
import org.apache.isis.extensions.commandreplay.secondary.job.ReplicateAndReplayJob;
import org.apache.isis.extensions.commandreplay.secondary.mixins.Object_openOnPrimary;
import org.apache.isis.extensions.commandreplay.secondary.ui.CommandReplayOnSecondaryService;
import org.apache.isis.extensions.quartz.IsisModuleExtQuartzImpl;
import org.apache.isis.extensions.quartz.spring.AutowiringSpringBeanJobFactory;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.spi.JobFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.scheduling.quartz.SimpleTriggerFactoryBean;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;

@Configuration
@Import(value={IsisModuleExtCommandLogImpl.class, IsisModuleExtQuartzImpl.class, CommandExecutorServiceWithTime.class, CommandFetcher.class, CommandReplayAnalyserResult.class, CommandReplayAnalyserException.class, CommandReplayAnalysisService.class, CommandReplayOnSecondaryService.class, TickingClockService.class, SecondaryConfig.class, Object_openOnPrimary.class})
@Profile(value={"secondary"})
public class IsisModuleExtCommandReplaySecondary {
    @Inject
    ApplicationContext applicationContext;
    @Inject
    IsisConfiguration isisConfiguration;

    @Bean(name={"ReplicateAndReplayJob"})
    public JobDetailFactoryBean replicateAndReplayJobDetailFactory() {
        JobDetailFactoryBean jobDetailFactory = new JobDetailFactoryBean();
        jobDetailFactory.setJobClass(ReplicateAndReplayJob.class);
        jobDetailFactory.setDescription("Replicate commands from primary and replay on secondary");
        jobDetailFactory.setDurability(true);
        return jobDetailFactory;
    }

    @Bean(name={"ReplicateAndReplayTrigger"})
    public SimpleTriggerFactoryBean replicateAndReplayTriggerFactory(@Qualifier(value="ReplicateAndReplayJob") JobDetail job) {
        SimpleTriggerFactoryBean triggerFactory = new SimpleTriggerFactoryBean();
        triggerFactory.setJobDetail(job);
        IsisConfiguration.Extensions.CommandReplay.QuartzReplicateAndReplayJob config = this.isisConfiguration.getExtensions().getCommandReplay().getQuartzReplicateAndReplayJob();
        triggerFactory.setRepeatInterval(config.getRepeatInterval());
        triggerFactory.setStartDelay(config.getStartDelay());
        triggerFactory.setRepeatCount(-1);
        return triggerFactory;
    }

    @Bean(name={"ReplicateAndReplaySbjf"})
    public SpringBeanJobFactory springBeanJobFactory() {
        AutowiringSpringBeanJobFactory jobFactory = new AutowiringSpringBeanJobFactory();
        jobFactory.setApplicationContext(this.applicationContext);
        return jobFactory;
    }

    @Bean(name={"ReplicateAndReplaySfb"})
    public SchedulerFactoryBean scheduler(@Qualifier(value="ReplicateAndReplayTrigger") Trigger trigger, @Qualifier(value="ReplicateAndReplayJob") JobDetail jobDetail, @Qualifier(value="ReplicateAndReplaySbjf") SpringBeanJobFactory sbjf) {
        SchedulerFactoryBean schedulerFactory = new SchedulerFactoryBean();
        schedulerFactory.setJobFactory((JobFactory)sbjf);
        schedulerFactory.setJobDetails(new JobDetail[]{jobDetail});
        schedulerFactory.setTriggers(new Trigger[]{trigger});
        return schedulerFactory;
    }

    @Bean(name={"ReplicateAndReplayScheduler"})
    public Scheduler scheduler(@Qualifier(value="ReplicateAndReplayTrigger") Trigger trigger, @Qualifier(value="ReplicateAndReplayJob") JobDetail job, @Qualifier(value="ReplicateAndReplaySfb") SchedulerFactoryBean factory) throws SchedulerException {
        Scheduler scheduler = factory.getScheduler();
        scheduler.start();
        return scheduler;
    }

    public static abstract class PropertyDomainEvent<S, T>
    extends org.apache.isis.applib.events.domain.PropertyDomainEvent<S, T> {
    }

    public static abstract class CollectionDomainEvent<S, T>
    extends org.apache.isis.applib.events.domain.CollectionDomainEvent<S, T> {
    }

    public static abstract class ActionDomainEvent<S>
    extends org.apache.isis.applib.events.domain.ActionDomainEvent<S> {
    }
}

