/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.layout.ordermethod;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.isis.core.commons.lang.JavaClassUtils;
import org.apache.isis.core.commons.lang.StringUtils;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.object.orderactions.ActionOrderFacet;
import org.apache.isis.core.metamodel.facets.object.orderfields.FieldOrderFacet;
import org.apache.isis.core.metamodel.layout.MemberLayoutArranger;
import org.apache.isis.core.metamodel.layout.OrderSet;
import org.apache.isis.core.metamodel.layout.ordermethod.SimpleOrderSet;
import org.apache.isis.core.metamodel.methodutils.MethodFinderUtils;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.log4j.Logger;

public class MemberLayoutArrangerUsingOrderMethod
implements MemberLayoutArranger {
    private static final Logger LOG = Logger.getLogger(MemberLayoutArrangerUsingOrderMethod.class);
    private static final Object[] NO_PARAMETERS = new Object[0];
    private static final Class<?>[] NO_PARAMETERS_TYPES = new Class[0];
    private static final String FIELD_PREFIX = null;
    private static final String ACTION_PREFIX = null;

    public OrderSet createAssociationOrderSetFor(ObjectSpecification spec, List<FacetedMethod> associationMethods) {
        FieldOrderFacet fieldOrderFacet;
        String fieldOrder;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MemberLayoutArrangerUsingOrderMethod: createAssociationOrderSetFor " + spec.getFullIdentifier()));
        }
        String string = fieldOrder = (fieldOrderFacet = (FieldOrderFacet)spec.getFacet(FieldOrderFacet.class)) == null ? null : fieldOrderFacet.value();
        if (fieldOrder == null) {
            fieldOrder = this.invokeSortOrderMethod(spec, FIELD_PREFIX);
        }
        return this.createOrderSet(fieldOrder, associationMethods);
    }

    public OrderSet createActionOrderSetFor(ObjectSpecification spec, List<FacetedMethod> actionFacetedMethodList) {
        ActionOrderFacet actionOrderFacet;
        String actionOrder;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MemberLayoutArrangerUsingOrderMethod: createAssociationOrderSetFor " + spec.getFullIdentifier()));
        }
        String string = actionOrder = (actionOrderFacet = (ActionOrderFacet)spec.getFacet(ActionOrderFacet.class)) == null ? null : actionOrderFacet.value();
        if (actionOrder == null) {
            actionOrder = this.invokeSortOrderMethod(spec, ACTION_PREFIX);
        }
        return this.createOrderSet(actionOrder, actionFacetedMethodList);
    }

    private String invokeSortOrderMethod(ObjectSpecification spec, String methodNamePrefix) {
        List<Method> methods = Arrays.asList(spec.getCorrespondingClass().getMethods());
        Method method = MethodFinderUtils.findMethod(methods, (MethodScope)MethodScope.CLASS, (String)(methodNamePrefix + "Order"), String.class, (Class[])NO_PARAMETERS_TYPES);
        if (method == null) {
            return null;
        }
        if (!JavaClassUtils.isStatic((Method)method)) {
            LOG.warn((Object)("method " + spec.getFullIdentifier() + "." + methodNamePrefix + "Order() must be declared as static"));
            return null;
        }
        try {
            String s = (String)method.invoke(null, NO_PARAMETERS);
            if (StringUtils.isNullOrEmpty((String)s)) {
                return null;
            }
            return s;
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)("method " + spec.getFullIdentifier() + "#" + method.getName() + "() should accept no parameters"));
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)("method " + spec.getFullIdentifier() + "#" + method.getName() + "() must be declared as public"));
            return null;
        }
        catch (InvocationTargetException e) {
            LOG.warn((Object)("method " + spec.getFullIdentifier() + "#" + method.getName() + "() has thrown an exception"));
            return null;
        }
    }

    private OrderSet createOrderSet(String order, List<FacetedMethod> members) {
        if (order == null) {
            return null;
        }
        return SimpleOrderSet.createOrderSet((String)order, members);
    }
}

