/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.value.timestamp;

import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.isis.applib.value.TimeStamp;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;
import org.apache.isis.core.progmodel.facets.value.ValueSemanticsProviderAbstractTemporal;

public abstract class TimeStampValueSemanticsProviderAbstract<T>
extends ValueSemanticsProviderAbstractTemporal<T> {
    private static final Object DEFAULT_VALUE = null;
    private static final int TYPICAL_LENGTH = 12;
    private static final boolean IMMUTABLE = false;
    private static final boolean EQUAL_BY_CONTENT = false;

    protected static void initFormats(Map<String, DateFormat> formats) {
        formats.put("iso", TimeStampValueSemanticsProviderAbstract.createDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
        formats.put("iso_encoding", TimeStampValueSemanticsProviderAbstract.createDateFormat("yyyyMMdd'T'HHmmssSSS"));
        formats.put("medium", DateFormat.getDateTimeInstance(2, 1));
        formats.put("short", DateFormat.getDateTimeInstance(3, 1));
    }

    public TimeStampValueSemanticsProviderAbstract(FacetHolder holder, Class<T> adaptedClass, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super("timestamp", holder, adaptedClass, 12, false, false, DEFAULT_VALUE, configuration, context);
        String formatRequired = configuration.getString("isis.value.format.timestamp");
        if (formatRequired == null) {
            this.format = this.formats().get(this.defaultFormat());
        } else {
            this.setMask(formatRequired);
        }
    }

    @Override
    public int getLevel() {
        return 273;
    }

    @Override
    protected T add(T original, int years, int months, int days, int hours, int minutes) {
        return original;
    }

    @Override
    protected Date dateValue(Object value) {
        return new Date(((TimeStamp)value).longValue());
    }

    @Override
    protected String defaultFormat() {
        return "short";
    }

    public String toString() {
        return "TimeStampValueSemanticsProvider: " + this.format;
    }
}

