/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.value.time;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Map;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;
import org.apache.isis.core.progmodel.facets.value.ValueSemanticsProviderAbstractTemporal;

public abstract class TimeValueSemanticsProviderAbstract<T>
extends ValueSemanticsProviderAbstractTemporal<T> {
    private static final Object DEFAULT_VALUE = null;
    private static final int TYPICAL_LENGTH = 6;
    private static final boolean IMMUTABLE = false;
    private static final boolean EQUAL_BY_CONTENT = false;

    protected static void initFormats(Map<String, DateFormat> formats) {
        formats.put("iso", TimeValueSemanticsProviderAbstract.createDateFormat("HH:mm"));
        formats.put("iso_sec", TimeValueSemanticsProviderAbstract.createDateFormat("HH:mm:ss"));
        formats.put("iso_milli", TimeValueSemanticsProviderAbstract.createDateFormat("HH:mm:ss.SSS"));
        formats.put("iso_encoding", TimeValueSemanticsProviderAbstract.createDateFormat("HHmmssSSS"));
        formats.put("long", DateFormat.getTimeInstance(1));
        formats.put("medium", DateFormat.getTimeInstance(2));
        formats.put("short", DateFormat.getTimeInstance(3));
    }

    public TimeValueSemanticsProviderAbstract(FacetHolder holder, Class<T> adaptedClass, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super("time", holder, adaptedClass, 6, false, false, DEFAULT_VALUE, configuration, context);
        String formatRequired = configuration.getString("isis.value.format.time");
        if (formatRequired == null) {
            this.format = this.formats().get(this.defaultFormat());
        } else {
            this.setMask(formatRequired);
        }
    }

    @Override
    public int getLevel() {
        return 16;
    }

    @Override
    protected void clearFields(Calendar cal) {
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
    }

    @Override
    protected String defaultFormat() {
        return "short";
    }

    public String toString() {
        return "TimeValueSemanticsProvider: " + this.format;
    }
}

