/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.value.floats;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;
import org.apache.isis.core.progmodel.facets.value.floats.FloatingPointValueFacet;

public class FloatValueSemanticsProviderAbstract
extends ValueSemanticsProviderAndFacetAbstract<Float>
implements FloatingPointValueFacet {
    private static final Float DEFAULT_VALUE = new Float(0.0f);
    private static final int TYPICAL_LENGTH = 12;
    private static final boolean IMMUTABLE = true;
    private static final boolean EQUAL_BY_CONTENT = true;
    private final NumberFormat format = this.determineNumberFormat("value.format.float");

    public static Class<? extends Facet> type() {
        return FloatingPointValueFacet.class;
    }

    public FloatValueSemanticsProviderAbstract(FacetHolder holder, Class<Float> adaptedClass, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(FloatValueSemanticsProviderAbstract.type(), holder, adaptedClass, 12, true, true, DEFAULT_VALUE, configuration, context);
    }

    @Override
    protected Float doParse(Object context, String entry) {
        try {
            return new Float(this.format.parse(entry).floatValue());
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Not a floating point number " + entry, (Throwable)e);
        }
    }

    @Override
    public String titleString(Object value, Localization localization) {
        return this.titleString(this.format, value);
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(new DecimalFormat(usingMask), value);
    }

    @Override
    protected String doEncode(Object object) {
        return object.toString();
    }

    @Override
    protected Float doRestore(String data) {
        return new Float(data);
    }

    @Override
    public Float floatValue(ObjectAdapter object) {
        return object == null ? null : (Float)object.getObject();
    }

    @Override
    public ObjectAdapter createValue(Float value) {
        return this.getAdapterMap().adapterFor((Object)value);
    }

    public String toString() {
        return "FloatValueSemanticsProvider: " + this.format;
    }
}

