/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.value.biginteger;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;
import org.apache.isis.core.progmodel.facets.value.biginteger.BigIntegerValueFacet;

public class BigIntegerValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<BigInteger>
implements BigIntegerValueFacet {
    private static final int TYPICAL_LENGTH = 19;
    private static final boolean IMMUTABLE = true;
    private static final boolean EQUAL_BY_CONTENT = true;
    private static final BigInteger DEFAULT_VALUE = BigInteger.valueOf(0L);
    private final NumberFormat format = this.determineNumberFormat("value.format.int");

    private static Class<? extends Facet> type() {
        return BigIntegerValueFacet.class;
    }

    public BigIntegerValueSemanticsProvider() {
        this(null, null, null);
    }

    public BigIntegerValueSemanticsProvider(FacetHolder holder, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(BigIntegerValueSemanticsProvider.type(), holder, BigInteger.class, 19, true, true, DEFAULT_VALUE, configuration, context);
    }

    @Override
    protected BigInteger doParse(Object context, String entry) {
        try {
            return new BigInteger(entry);
        }
        catch (NumberFormatException e) {
            throw new TextEntryParseException("Not an integer " + entry, (Throwable)e);
        }
    }

    @Override
    public String titleString(Object object, Localization localization) {
        return this.titleString(this.format, object);
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(new DecimalFormat(usingMask), value);
    }

    @Override
    protected String doEncode(Object object) {
        return object.toString();
    }

    @Override
    protected BigInteger doRestore(String data) {
        return new BigInteger(data);
    }

    public String toString() {
        return "BigIntegerValueSemanticsProvider: " + this.format;
    }
}

