/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.validate.regexannot;

import java.lang.reflect.Method;
import org.apache.isis.applib.annotation.RegEx;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.AnnotationBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.progmodel.facets.object.regex.RegExFacet;
import org.apache.isis.core.progmodel.facets.object.regex.TitleFacetFormattedByRegex;
import org.apache.isis.core.progmodel.facets.properties.validate.regexannot.RegExFacetAnnotationForProperty;

public class RegExFacetAnnotationForPropertyFacetFactory
extends AnnotationBasedFacetFactoryAbstract {
    public RegExFacetAnnotationForPropertyFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> returnType = processMethodContext.getMethod().getReturnType();
        if (!this.isString(returnType)) {
            return;
        }
        RegEx annotation = (RegEx)RegExFacetAnnotationForPropertyFacetFactory.getAnnotation((Method)processMethodContext.getMethod(), RegEx.class);
        this.addRegexFacetAndCorrespondingTitleFacet(processMethodContext.getFacetHolder(), annotation);
    }

    private void addRegexFacetAndCorrespondingTitleFacet(FacetHolder holder, RegEx annotation) {
        RegExFacet regexFacet = this.createRegexFacet(annotation, holder);
        if (regexFacet == null) {
            return;
        }
        FacetUtil.addFacet((Facet)regexFacet);
        TitleFacet titleFacet = this.createTitleFacet(regexFacet);
        FacetUtil.addFacet((Facet)titleFacet);
    }

    private RegExFacet createRegexFacet(RegEx annotation, FacetHolder holder) {
        if (annotation == null) {
            return null;
        }
        String validationExpression = annotation.validation();
        boolean caseSensitive = annotation.caseSensitive();
        String formatExpression = annotation.format();
        return new RegExFacetAnnotationForProperty(validationExpression, formatExpression, caseSensitive, holder);
    }

    private TitleFacet createTitleFacet(RegExFacet regexFacet) {
        return new TitleFacetFormattedByRegex(regexFacet);
    }
}

