/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.validate.maskannot;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.isis.applib.annotation.Mask;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.AnnotationBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.progmodel.facets.object.mask.MaskFacet;
import org.apache.isis.core.progmodel.facets.object.mask.TitleFacetBasedOnMask;
import org.apache.isis.core.progmodel.facets.properties.validate.maskannot.MaskFacetAnnotationForProperty;

public class MaskAnnotationForPropertyFacetFactory
extends AnnotationBasedFacetFactoryAbstract {
    public MaskAnnotationForPropertyFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY);
    }

    public void process(FacetFactory.ProcessClassContext processClassContaxt) {
        Mask annotation = (Mask)MaskAnnotationForPropertyFacetFactory.getAnnotation((Class)processClassContaxt.getCls(), Mask.class);
        FacetUtil.addFacet((Facet)this.createMaskFacet(annotation, processClassContaxt.getFacetHolder()));
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        if (processMethodContext.getMethod().getReturnType() == Void.TYPE) {
            return;
        }
        Mask annotation = (Mask)MaskAnnotationForPropertyFacetFactory.getAnnotation((Method)processMethodContext.getMethod(), Mask.class);
        this.addMaskFacetAndCorrespondingTitleFacet(processMethodContext.getFacetHolder(), annotation, processMethodContext.getMethod().getReturnType());
    }

    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        Class<?>[] parameterTypes = processParameterContext.getMethod().getParameterTypes();
        if (processParameterContext.getParamNum() >= parameterTypes.length) {
            return;
        }
        Annotation[] parameterAnnotations = MaskAnnotationForPropertyFacetFactory.getParameterAnnotations((Method)processParameterContext.getMethod())[processParameterContext.getParamNum()];
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            if (!(parameterAnnotations[i] instanceof Mask)) continue;
            Mask annotation = (Mask)parameterAnnotations[i];
            this.addMaskFacetAndCorrespondingTitleFacet(processParameterContext.getFacetHolder(), annotation, parameterTypes[i]);
            return;
        }
    }

    private MaskFacet createMaskFacet(Mask annotation, FacetHolder holder) {
        return annotation != null ? new MaskFacetAnnotationForProperty(annotation.value(), null, holder) : null;
    }

    private boolean addMaskFacetAndCorrespondingTitleFacet(FacetHolder holder, Mask annotation, Class<?> cls) {
        MaskFacet maskFacet = this.createMaskFacet(annotation, holder);
        if (maskFacet == null) {
            return false;
        }
        FacetUtil.addFacet((Facet)maskFacet);
        ObjectSpecification type = this.getSpecificationLookup().loadSpecification(cls);
        TitleFacet underlyingTitleFacet = (TitleFacet)type.getFacet(TitleFacet.class);
        if (underlyingTitleFacet != null) {
            TitleFacetBasedOnMask titleFacet = new TitleFacetBasedOnMask(maskFacet, underlyingTitleFacet);
            FacetUtil.addFacet((Facet)titleFacet);
        }
        return true;
    }
}

