/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.validate;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.properties.validate.PropertyValidateFacetViaMethod;

public class PropertyValidateFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"validate"};

    public PropertyValidateFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachValidateFacetIfValidateMethodIsFound(processMethodContext);
    }

    private void attachValidateFacetIfValidateMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method getMethod = processMethodContext.getMethod();
        String capitalizedName = NameUtils.javaBaseName((String)getMethod.getName());
        Class<?> returnType = getMethod.getReturnType();
        Class[] paramTypes = new Class[]{returnType};
        Class cls = processMethodContext.getCls();
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "validate" + capitalizedName, String.class, paramTypes);
        if (method == null) {
            return;
        }
        processMethodContext.removeMethod(method);
        FacetHolder property = processMethodContext.getFacetHolder();
        FacetUtil.addFacet((Facet)new PropertyValidateFacetViaMethod(method, property));
    }
}

