/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.modify;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.properties.modify.PropertySetterFacetViaModifyMethod;

public class PropertyModifyFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"modify"};

    public PropertyModifyFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachPropertyModifyFacetIfModifyMethodIsFound(processMethodContext);
    }

    private void attachPropertyModifyFacetIfModifyMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method getMethod = processMethodContext.getMethod();
        String capitalizedName = NameUtils.javaBaseName((String)getMethod.getName());
        Class<?> returnType = getMethod.getReturnType();
        Class[] paramTypes = new Class[]{returnType};
        Class cls = processMethodContext.getCls();
        Method modifyMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "modify" + capitalizedName, Void.TYPE, paramTypes);
        if (modifyMethod == null) {
            return;
        }
        processMethodContext.removeMethod(modifyMethod);
        FacetHolder property = processMethodContext.getFacetHolder();
        FacetUtil.addFacet((Facet)new PropertySetterFacetViaModifyMethod(modifyMethod, property));
    }
}

