/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.mandatory.staticmethod;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.metamodel.adapter.util.InvokeUtils;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.properties.mandatory.staticmethod.MandatoryFacetOptionalViaMethodForProperty;

public class PropertyOptionalFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"optional"};

    public PropertyOptionalFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        PropertyOptionalFacetFactory.attachMandatoryFacetIfOptionalMethodIsFound(processMethodContext);
    }

    private static void attachMandatoryFacetIfOptionalMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        String capitalizedName = NameUtils.javaBaseName((String)method.getName());
        Class<?> returnType = method.getReturnType();
        Class cls = processMethodContext.getCls();
        Method optionalMethod = MethodFinderUtils.findMethod(cls, MethodScope.CLASS, "optional" + capitalizedName, Boolean.TYPE, NO_PARAMETERS_TYPES);
        processMethodContext.removeMethod(optionalMethod);
        if (!PropertyOptionalFacetFactory.indicatesOptional(optionalMethod)) {
            return;
        }
        if (returnType.isPrimitive()) {
            throw new MetaModelException(cls.getName() + "#" + capitalizedName + " cannot be an optional property as it is of a primitive type");
        }
        FacetHolder property = processMethodContext.getFacetHolder();
        FacetUtil.addFacet((Facet)new MandatoryFacetOptionalViaMethodForProperty(property));
    }

    private static boolean indicatesOptional(Method method) {
        if (method != null) {
            Boolean optionalMethodReturnValue = null;
            try {
                optionalMethodReturnValue = (Boolean)InvokeUtils.invoke((Method)method, (Object)new Object[0]);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (optionalMethodReturnValue == null) {
                throw new MetaModelException("method " + method + " should return a boolean");
            }
            return optionalMethodReturnValue;
        }
        return false;
    }
}

