/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.accessor;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MethodRemover;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.PropertyOrCollectionIdentifyingFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.properties.accessor.PropertyAccessorFacetViaAccessor;

public class PropertyAccessorFacetFactory
extends PropertyOrCollectionIdentifyingFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"get", "is"};

    public PropertyAccessorFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        PropertyAccessorFacetFactory.attachPropertyAccessFacetForAccessorMethod(processMethodContext);
    }

    private static void attachPropertyAccessFacetForAccessorMethod(FacetFactory.ProcessMethodContext processMethodContext) {
        Method accessorMethod = processMethodContext.getMethod();
        processMethodContext.removeMethod(accessorMethod);
        FacetHolder property = processMethodContext.getFacetHolder();
        FacetUtil.addFacet((Facet)new PropertyAccessorFacetViaAccessor(accessorMethod, property));
    }

    public boolean isPropertyOrCollectionAccessorCandidate(Method method) {
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return true;
        }
        return methodName.startsWith("is") && method.getReturnType() == Boolean.TYPE;
    }

    public boolean isCollectionAccessor(Method method) {
        return false;
    }

    public boolean isPropertyAccessor(Method method) {
        if (!this.isPropertyOrCollectionAccessorCandidate(method)) {
            return false;
        }
        Class<?> methodReturnType = method.getReturnType();
        return this.isCollectionOrArray(methodReturnType);
    }

    public void findAndRemovePropertyAccessors(MethodRemover methodRemover, List<Method> methodListToAppendTo) {
        PropertyAccessorFacetFactory.appendMatchingMethods(methodRemover, "is", Boolean.TYPE, methodListToAppendTo);
        PropertyAccessorFacetFactory.appendMatchingMethods(methodRemover, "get", Object.class, methodListToAppendTo);
    }

    private static void appendMatchingMethods(MethodRemover methodRemover, String prefix, Class<?> returnType, List<Method> methodListToAppendTo) {
        methodListToAppendTo.addAll(methodRemover.removeMethods(MethodScope.OBJECT, prefix, returnType, false, 0));
    }

    public void findAndRemoveCollectionAccessors(MethodRemover methodRemover, List<Method> methodListToAppendTo) {
    }
}

