/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.param.describedas.staticmethod;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.map.AdapterMapAware;
import org.apache.isis.core.metamodel.adapter.util.InvokeUtils;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.members.describedas.staticmethod.DescribedAsFacetViaMethod;

public class ActionParameterDescriptionsMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements AdapterMapAware {
    private static final String[] PREFIXES = new String[]{"description"};
    private AdapterMap adapterMap;

    public ActionParameterDescriptionsMethodFacetFactory() {
        super(FeatureType.ACTIONS_ONLY, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
        List holderList = facetedMethod.getParameters();
        ActionParameterDescriptionsMethodFacetFactory.attachDescribedAsFacetForParametersIfParameterDescriptionsMethodIsFound(processMethodContext, holderList);
    }

    private static void attachDescribedAsFacetForParametersIfParameterDescriptionsMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext, List<FacetedMethodParameter> parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = NameUtils.capitalizeName((String)actionMethod.getName());
        Class cls = processMethodContext.getCls();
        Method descriptionMethod = MethodFinderUtils.findMethod(cls, MethodScope.CLASS, "description" + capitalizedName, String[].class, new Class[0]);
        if (descriptionMethod == null) {
            return;
        }
        processMethodContext.removeMethod(descriptionMethod);
        String[] descriptions = ActionParameterDescriptionsMethodFacetFactory.invokeDescriptionsMethod(descriptionMethod, parameters.size());
        for (int i = 0; i < descriptions.length; ++i) {
            FacetUtil.addFacet((Facet)new DescribedAsFacetViaMethod(descriptions[i], descriptionMethod, (FacetHolder)parameters.get(i)));
        }
    }

    private static String[] invokeDescriptionsMethod(Method descriptionMethod, int numElementsRequired) {
        String[] descriptions = null;
        try {
            descriptions = (String[])InvokeUtils.invokeStatic((Method)descriptionMethod, (Object[])new Object[0]);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (descriptions == null || descriptions.length != numElementsRequired) {
            throw new MetaModelException(descriptionMethod + " must return an String[] array of same size as number of parameters of action");
        }
        return descriptions;
    }

    public void setAdapterMap(AdapterMap adapterMap) {
        this.adapterMap = adapterMap;
    }

    private AdapterMap getAdapterMap() {
        return this.adapterMap;
    }
}

