/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.param.choices.methodnum;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.lang.ArrayUtil;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLookup;
import org.apache.isis.core.progmodel.facets.CollectionUtils;
import org.apache.isis.core.progmodel.facets.param.choices.ActionParameterChoicesFacetAbstract;

public class ActionParameterChoicesFacetViaMethod
extends ActionParameterChoicesFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final Class<?> choicesType;

    public ActionParameterChoicesFacetViaMethod(Method method, Class<?> choicesType, FacetHolder holder, SpecificationLookup specificationLookup, AdapterMap adapterManager) {
        super(holder, specificationLookup, adapterManager);
        this.method = method;
        this.choicesType = choicesType;
    }

    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    public boolean impliesResolve() {
        return true;
    }

    public boolean impliesObjectChanged() {
        return false;
    }

    public Object[] getChoices(ObjectAdapter owningAdapter) {
        Object options = AdapterInvokeUtils.invoke((Method)this.method, (ObjectAdapter)owningAdapter);
        if (options == null) {
            return new Object[0];
        }
        if (options.getClass().isArray()) {
            return ArrayUtil.getObjectAsObjectArray((Object)options);
        }
        ObjectSpecification specification = this.getSpecification(this.choicesType);
        return CollectionUtils.getCollectionAsObjectArray(options, specification, this.getAdapterMap());
    }

    protected String toStringValues() {
        return "method=" + this.method + ",type=" + this.choicesType;
    }
}

