/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.param.choices.methodnum;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.map.AdapterMapAware;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.actions.choices.ActionChoicesFacet;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.param.choices.methodnum.ActionParameterChoicesFacetViaMethod;

public class ActionParameterChoicesFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements AdapterMapAware {
    private static final String[] PREFIXES = new String[0];
    private AdapterMap adapterMap;

    public ActionParameterChoicesFacetFactory() {
        super(FeatureType.ACTIONS_ONLY, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
        List holderList = facetedMethod.getParameters();
        this.attachChoicesFacetForParametersIfChoicesNumMethodIsFound(processMethodContext, holderList);
    }

    private void attachChoicesFacetForParametersIfChoicesNumMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext, List<FacetedMethodParameter> parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        Method actionMethod = processMethodContext.getMethod();
        Class<?>[] params = actionMethod.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            Class<?> arrayOfParamType = Array.newInstance(params[i], 0).getClass();
            Method choicesMethod = this.findChoicesNumMethodReturning(processMethodContext, i, arrayOfParamType);
            if (choicesMethod == null) {
                choicesMethod = this.findChoicesNumMethodReturning(processMethodContext, i, List.class);
            }
            if (choicesMethod == null) continue;
            processMethodContext.removeMethod(choicesMethod);
            FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
            if (facetedMethod.containsDoOpFacet(ActionChoicesFacet.class)) {
                Class cls = processMethodContext.getCls();
                throw new MetaModelException(cls + " uses both old and new choices syntax - must use one or other");
            }
            FacetedMethodParameter paramAsHolder = parameters.get(i);
            FacetUtil.addFacet((Facet)new ActionParameterChoicesFacetViaMethod(choicesMethod, arrayOfParamType, (FacetHolder)paramAsHolder, this.getSpecificationLookup(), this.getAdapterMap()));
        }
    }

    private Method findChoicesNumMethodReturning(FacetFactory.ProcessMethodContext processMethodContext, int i, Class<?> arrayOfParamType) {
        Class cls = processMethodContext.getCls();
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = NameUtils.capitalizeName((String)actionMethod.getName());
        String name = "choices" + i + capitalizedName;
        return MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, name, arrayOfParamType, new Class[0]);
    }

    public void setAdapterMap(AdapterMap adapterMap) {
        this.adapterMap = adapterMap;
    }

    private AdapterMap getAdapterMap() {
        return this.adapterMap;
    }
}

