/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.param.choices.method;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.map.AdapterMapAware;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.param.choices.method.ActionChoicesFacetViaMethod;

public class ActionChoicesFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements AdapterMapAware {
    private static final String[] PREFIXES = new String[]{"choices"};
    private AdapterMap adapterMap;

    public ActionChoicesFacetFactory() {
        super(FeatureType.ACTIONS_ONLY, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachActionChoicesFacetIfParameterChoicesMethodIsFound(processMethodContext);
    }

    private void attachActionChoicesFacetIfParameterChoicesMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method actionMethod = processMethodContext.getMethod();
        Class<?>[] actionParamTypes = actionMethod.getParameterTypes();
        if (actionParamTypes.length <= 0) {
            return;
        }
        Method choicesMethod = null;
        if (choicesMethod == null) {
            choicesMethod = this.findChoicesMethodReturning(processMethodContext, Object[][].class);
        }
        if (choicesMethod == null) {
            choicesMethod = this.findChoicesMethodReturning(processMethodContext, Object[].class);
        }
        if (choicesMethod == null) {
            choicesMethod = this.findChoicesMethodReturning(processMethodContext, List.class);
        }
        if (choicesMethod == null) {
            return;
        }
        processMethodContext.removeMethod(choicesMethod);
        Class<?> returnType = actionMethod.getReturnType();
        FacetHolder action = processMethodContext.getFacetHolder();
        ActionChoicesFacetViaMethod facet = new ActionChoicesFacetViaMethod(choicesMethod, returnType, action, this.getSpecificationLookup(), this.getAdapterMap());
        FacetUtil.addFacet((Facet)facet);
    }

    protected Method findChoicesMethodReturning(FacetFactory.ProcessMethodContext processMethodContext, Class<?> returnType2) {
        Class cls = processMethodContext.getCls();
        Method actionMethod = processMethodContext.getMethod();
        MethodScope methodScope = MethodScope.scopeFor((Method)actionMethod);
        String capitalizedName = NameUtils.capitalizeName((String)actionMethod.getName());
        String name = "choices" + capitalizedName;
        Method choicesMethod = MethodFinderUtils.findMethod(cls, methodScope, name, returnType2, new Class[0]);
        return choicesMethod;
    }

    public void setAdapterMap(AdapterMap adapterMap) {
        this.adapterMap = adapterMap;
    }

    protected AdapterMap getAdapterMap() {
        return this.adapterMap;
    }
}

