/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.value.annotation;

import org.apache.isis.applib.annotation.Value;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProviderAware;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.commons.lang.StringUtils;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.map.AdapterMapAware;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MultiTypedFacet;
import org.apache.isis.core.metamodel.facets.AnnotationBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjector;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjectorAware;
import org.apache.isis.core.progmodel.facets.object.value.ValueFacetFromConfiguration;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderUtil;
import org.apache.isis.core.progmodel.facets.object.value.annotation.ValueFacetAnnotation;

public class ValueFacetFactory
extends AnnotationBasedFacetFactoryAbstract
implements IsisConfigurationAware,
AuthenticationSessionProviderAware,
AdapterMapAware,
DependencyInjectorAware {
    private IsisConfiguration configuration;
    private AuthenticationSessionProvider authenticationSessionProvider;
    private AdapterMap adapterManager;
    private DependencyInjector dependencyInjector;

    public ValueFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    public void process(FacetFactory.ProcessClassContext processClassContaxt) {
        FacetUtil.addFacet((MultiTypedFacet)this.create(processClassContaxt.getCls(), processClassContaxt.getFacetHolder()));
    }

    private ValueFacet create(Class<?> cls, FacetHolder holder) {
        ValueFacetFromConfiguration facet;
        ValueFacetAnnotation facet2;
        Value annotation = (Value)ValueFacetFactory.getAnnotation(cls, Value.class);
        if (annotation != null && (facet2 = new ValueFacetAnnotation(cls, holder, this.getIsisConfiguration(), this.createValueSemanticsProviderContext())).isValid()) {
            return facet2;
        }
        String semanticsProviderName = ValueSemanticsProviderUtil.semanticsProviderNameFromConfiguration(cls, this.configuration);
        if (!StringUtils.isNullOrEmpty((String)semanticsProviderName) && (facet = new ValueFacetFromConfiguration(semanticsProviderName, holder, this.getIsisConfiguration(), this.createValueSemanticsProviderContext())).isValid()) {
            return facet;
        }
        return null;
    }

    protected ValueSemanticsProviderContext createValueSemanticsProviderContext() {
        return new ValueSemanticsProviderContext(this.getAuthenticationSessionProvider(), this.getSpecificationLookup(), this.getAdapterManager(), this.getDependencyInjector());
    }

    public IsisConfiguration getIsisConfiguration() {
        return this.configuration;
    }

    public void setIsisConfiguration(IsisConfiguration configuration) {
        this.configuration = configuration;
    }

    public AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.authenticationSessionProvider;
    }

    public void setAuthenticationSessionProvider(AuthenticationSessionProvider authenticationSessionProvider) {
        this.authenticationSessionProvider = authenticationSessionProvider;
    }

    public AdapterMap getAdapterManager() {
        return this.adapterManager;
    }

    public void setAdapterMap(AdapterMap adapterManager) {
        this.adapterManager = adapterManager;
    }

    public DependencyInjector getDependencyInjector() {
        return this.dependencyInjector;
    }

    public void setDependencyInjector(DependencyInjector dependencyInjector) {
        this.dependencyInjector = dependencyInjector;
    }
}

