/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.value;

import org.apache.isis.applib.adapters.ValueSemanticsProvider;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.JavaClassUtils;
import org.apache.isis.core.commons.lang.StringUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;

public final class ValueSemanticsProviderUtil {
    public static final String SEMANTICS_PROVIDER_NAME_KEY_PREFIX = "isis.core.progmodel.value.";
    public static final String SEMANTICS_PROVIDER_NAME_KEY_SUFFIX = ".semanticsProviderName";

    private ValueSemanticsProviderUtil() {
    }

    public static String semanticsProviderNameFromConfiguration(Class<?> type, IsisConfiguration configuration) {
        String key = SEMANTICS_PROVIDER_NAME_KEY_PREFIX + type.getCanonicalName() + SEMANTICS_PROVIDER_NAME_KEY_SUFFIX;
        String semanticsProviderName = configuration.getString(key);
        return !StringUtils.isNullOrEmpty((String)semanticsProviderName) ? semanticsProviderName : null;
    }

    public static Class<? extends ValueSemanticsProvider<?>> valueSemanticsProviderOrNull(Class<?> candidateClass, String classCandidateName) {
        Class clazz = candidateClass != null ? JavaClassUtils.implementingClassOrNull((String)candidateClass.getName(), ValueSemanticsProvider.class, FacetHolder.class) : null;
        return clazz != null ? clazz : JavaClassUtils.implementingClassOrNull((String)classCandidateName, ValueSemanticsProvider.class, FacetHolder.class);
    }
}

