/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.parseable;

import java.util.IllegalFormatException;
import org.apache.isis.applib.adapters.Parser;
import org.apache.isis.applib.adapters.ParsingException;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.util.AdapterUtils;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.consent.InteractionResultSet;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.ParseableFacet;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.ObjectValidityContext;
import org.apache.isis.core.metamodel.interactions.ParseValueContext;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public class ParseableFacetUsingParser
extends FacetAbstract
implements ParseableFacet {
    private final Parser parser;
    private final DependencyInjector dependencyInjector;
    private final AdapterMap adapterMap;
    private final AuthenticationSessionProvider authenticationSessionProvider;

    public ParseableFacetUsingParser(Parser parser, FacetHolder holder, AuthenticationSessionProvider authenticationSessionProvider, DependencyInjector dependencyInjector, AdapterMap adapterManager) {
        super(ParseableFacet.class, holder, false);
        this.parser = parser;
        this.authenticationSessionProvider = authenticationSessionProvider;
        this.dependencyInjector = dependencyInjector;
        this.adapterMap = adapterManager;
    }

    protected String toStringValues() {
        this.dependencyInjector.injectDependenciesInto((Object)this.parser);
        return this.parser.toString();
    }

    public ObjectAdapter parseTextEntry(ObjectAdapter contextAdapter, String entry) {
        if (entry == null) {
            throw new IllegalArgumentException("An entry must be provided");
        }
        if (this.getFacetHolder().containsFacet(ValueFacet.class)) {
            ObjectAdapter entryAdapter = this.getAdapterMap().adapterFor((Object)entry);
            ParseValueContext parseValueContext = new ParseValueContext(this.getAuthenticationSessionProvider().getAuthenticationSession(), InteractionInvocationMethod.BY_USER, contextAdapter, this.getIdentified().getIdentifier(), entryAdapter);
            this.validate((ValidityContext<?>)parseValueContext);
        }
        Object context = AdapterUtils.unwrap((ObjectAdapter)contextAdapter);
        this.getDependencyInjector().injectDependenciesInto((Object)this.parser);
        try {
            Object parsed = this.parser.parseTextEntry(context, entry);
            if (parsed == null) {
                return null;
            }
            ObjectAdapter adapter = this.getAdapterMap().adapterFor(parsed);
            ObjectSpecification specification = adapter.getSpecification();
            ObjectValidityContext validateContext = specification.createValidityInteractionContext(this.getAuthenticationSessionProvider().getAuthenticationSession(), InteractionInvocationMethod.BY_USER, adapter);
            this.validate((ValidityContext<?>)validateContext);
            return adapter;
        }
        catch (NumberFormatException e) {
            throw new TextEntryParseException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalFormatException e) {
            throw new TextEntryParseException(e.getMessage(), (Throwable)e);
        }
        catch (ParsingException e) {
            throw new TextEntryParseException(e.getMessage(), (Throwable)e);
        }
    }

    private void validate(ValidityContext<?> validityContext) {
        InteractionResultSet resultSet = new InteractionResultSet();
        InteractionUtils.isValidResultSet((FacetHolder)this.getFacetHolder(), validityContext, (InteractionResultSet)resultSet);
        if (resultSet.isVetoed()) {
            throw new IllegalArgumentException(resultSet.getInteractionResult().getReason());
        }
    }

    public String parseableTitle(ObjectAdapter contextAdapter) {
        Object pojo = AdapterUtils.unwrap((ObjectAdapter)contextAdapter);
        this.getDependencyInjector().injectDependenciesInto((Object)this.parser);
        return this.parser.parseableTitleOf(pojo);
    }

    public DependencyInjector getDependencyInjector() {
        return this.dependencyInjector;
    }

    public AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.authenticationSessionProvider;
    }

    public AdapterMap getAdapterMap() {
        return this.adapterMap;
    }
}

