/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.parseable;

import org.apache.isis.applib.annotation.Parseable;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProviderAware;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.commons.lang.StringUtils;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.map.AdapterMapAware;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.AnnotationBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjector;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjectorAware;
import org.apache.isis.core.progmodel.facets.object.parseable.ParseableFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.parseable.ParseableFacetAnnotation;
import org.apache.isis.core.progmodel.facets.object.parseable.ParseableFacetFromConfiguration;
import org.apache.isis.core.progmodel.facets.object.parseable.ParserUtil;

public class ParseableFacetFactory
extends AnnotationBasedFacetFactoryAbstract
implements IsisConfigurationAware,
AuthenticationSessionProviderAware,
AdapterMapAware,
DependencyInjectorAware {
    private IsisConfiguration configuration;
    private AuthenticationSessionProvider authenticationSessionProvider;
    private AdapterMap adapterManager;
    private DependencyInjector dependencyInjector;

    public ParseableFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    public void process(FacetFactory.ProcessClassContext processClassContaxt) {
        FacetUtil.addFacet((Facet)this.create(processClassContaxt.getCls(), processClassContaxt.getFacetHolder()));
    }

    private ParseableFacetAbstract create(Class<?> cls, FacetHolder holder) {
        ParseableFacetFromConfiguration facet;
        ParseableFacetAnnotation facet2;
        Parseable annotation = (Parseable)ParseableFacetFactory.getAnnotation(cls, Parseable.class);
        if (annotation != null && (facet2 = new ParseableFacetAnnotation(cls, this.getIsisConfiguration(), holder, this.authenticationSessionProvider, this.adapterManager, this.dependencyInjector)).isValid()) {
            return facet2;
        }
        String parserName = ParserUtil.parserNameFromConfiguration(cls, this.getIsisConfiguration());
        if (!StringUtils.isNullOrEmpty((String)parserName) && (facet = new ParseableFacetFromConfiguration(parserName, holder, this.authenticationSessionProvider, this.dependencyInjector, this.adapterManager)).isValid()) {
            return facet;
        }
        return null;
    }

    public IsisConfiguration getIsisConfiguration() {
        return this.configuration;
    }

    public void setIsisConfiguration(IsisConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setAuthenticationSessionProvider(AuthenticationSessionProvider authenticationSessionProvider) {
        this.authenticationSessionProvider = authenticationSessionProvider;
    }

    public void setAdapterMap(AdapterMap adapterManager) {
        this.adapterManager = adapterManager;
    }

    public void setDependencyInjector(DependencyInjector dependencyInjector) {
        this.dependencyInjector = dependencyInjector;
    }
}

