/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.parseable;

import org.apache.isis.applib.annotation.Parseable;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.StringUtils;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjector;
import org.apache.isis.core.progmodel.facets.object.parseable.ParseableFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.parseable.ParserUtil;

public class ParseableFacetAnnotation
extends ParseableFacetAbstract {
    private static String parserName(Class<?> annotatedClass, IsisConfiguration configuration) {
        Parseable annotation = annotatedClass.getAnnotation(Parseable.class);
        String parserName = annotation.parserName();
        if (!StringUtils.isNullOrEmpty((String)parserName)) {
            return parserName;
        }
        return ParserUtil.parserNameFromConfiguration(annotatedClass, configuration);
    }

    private static Class<?> parserClass(Class<?> annotatedClass) {
        Parseable annotation = annotatedClass.getAnnotation(Parseable.class);
        return annotation.parserClass();
    }

    public ParseableFacetAnnotation(Class<?> annotatedClass, IsisConfiguration configuration, FacetHolder holder, AuthenticationSessionProvider authenticationSessionProvider, AdapterMap adapterManager, DependencyInjector dependencyInjector) {
        this(ParseableFacetAnnotation.parserName(annotatedClass, configuration), ParseableFacetAnnotation.parserClass(annotatedClass), holder, authenticationSessionProvider, adapterManager, dependencyInjector);
    }

    private ParseableFacetAnnotation(String candidateParserName, Class<?> candidateParserClass, FacetHolder holder, AuthenticationSessionProvider authenticationSessionProvider, AdapterMap adapterManager, DependencyInjector dependencyInjector) {
        super(candidateParserName, candidateParserClass, holder, authenticationSessionProvider, dependencyInjector, adapterManager);
    }
}

