/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.ignore.javalang;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.JavaClassUtils;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MethodRemover;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;

public class RemoveSuperclassMethodsFacetFactory
extends FacetFactoryAbstract {
    private static final String JAVA_CLASS_PREFIX = "java.";

    public RemoveSuperclassMethodsFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    public void process(FacetFactory.ProcessClassContext processClassContext) {
        this.removeSuperclassMethods(processClassContext.getCls(), (MethodRemover)processClassContext);
    }

    private void removeSuperclassMethods(Class<?> type, MethodRemover methodRemover) {
        Method[] methods;
        if (type == null) {
            return;
        }
        if (!JavaClassUtils.isJavaClass(type)) {
            this.removeSuperclassMethods(type.getSuperclass(), methodRemover);
            return;
        }
        for (Method method : methods = type.getMethods()) {
            methodRemover.removeMethod(method);
        }
    }
}

