/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.ignore.javalang;

import java.lang.reflect.Method;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class RemoveJavaLangObjectMethodsFacetFactory
extends FacetFactoryAbstract {
    private static final String[] objectMethodNames;
    private static final Class<?>[] objectMethodReturnTypes;
    private static final Class<?>[][] objectMethodParameters;

    public RemoveJavaLangObjectMethodsFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Method[] methods = Object.class.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            processClassContext.removeMethod(MethodScope.OBJECT, objectMethodNames[i], null, objectMethodParameters[i]);
        }
    }

    static {
        Method[] methods = Object.class.getMethods();
        int size = methods.length;
        objectMethodNames = new String[size];
        objectMethodReturnTypes = new Class[size];
        objectMethodParameters = new Class[size][];
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            RemoveJavaLangObjectMethodsFacetFactory.objectMethodNames[i] = method.getName();
            RemoveJavaLangObjectMethodsFacetFactory.objectMethodReturnTypes[i] = method.getReturnType();
            RemoveJavaLangObjectMethodsFacetFactory.objectMethodParameters[i] = method.getParameterTypes();
        }
    }
}

