/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.encodeable;

import org.apache.isis.applib.adapters.EncoderDecoder;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.JavaClassUtils;
import org.apache.isis.core.commons.lang.StringUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;

public final class EncoderDecoderUtil {
    public static final String ENCODER_DECODER_NAME_KEY_PREFIX = "isis.reflector.java.facets.encoderDecoder.";
    public static final String ENCODER_DECODER_NAME_KEY_SUFFIX = ".encoderDecoderName";

    private EncoderDecoderUtil() {
    }

    static String encoderDecoderNameFromConfiguration(Class<?> type, IsisConfiguration configuration) {
        String key = ENCODER_DECODER_NAME_KEY_PREFIX + type.getCanonicalName() + ENCODER_DECODER_NAME_KEY_SUFFIX;
        String encoderDecoderName = configuration.getString(key);
        return !StringUtils.isNullOrEmpty((String)encoderDecoderName) ? encoderDecoderName : null;
    }

    public static Class<?> encoderDecoderOrNull(Class<?> candidateClass, String classCandidateName) {
        Class type = candidateClass != null ? JavaClassUtils.implementingClassOrNull((String)candidateClass.getName(), EncoderDecoder.class, FacetHolder.class) : null;
        return type != null ? type : JavaClassUtils.implementingClassOrNull((String)classCandidateName, EncoderDecoder.class, FacetHolder.class);
    }
}

