/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.encodeable;

import org.apache.isis.applib.annotation.Encodable;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.commons.lang.StringUtils;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.map.AdapterMapAware;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.AnnotationBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjector;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjectorAware;
import org.apache.isis.core.progmodel.facets.object.encodeable.EncodableFacetAnnotation;
import org.apache.isis.core.progmodel.facets.object.encodeable.EncodableFacetFromConfiguration;
import org.apache.isis.core.progmodel.facets.object.encodeable.EncoderDecoderUtil;

public class EncodableAnnotationFacetFactory
extends AnnotationBasedFacetFactoryAbstract
implements IsisConfigurationAware,
DependencyInjectorAware,
AdapterMapAware {
    private IsisConfiguration configuration;
    private AdapterMap adapterManager;
    private DependencyInjector dependencyInjector;

    public EncodableAnnotationFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    public void process(FacetFactory.ProcessClassContext processClassContaxt) {
        FacetUtil.addFacet((Facet)this.create(processClassContaxt.getCls(), processClassContaxt.getFacetHolder()));
    }

    private EncodableFacet create(Class<?> cls, FacetHolder holder) {
        EncodableFacetFromConfiguration facet;
        EncodableFacetAnnotation facet2;
        Encodable annotation = (Encodable)EncodableAnnotationFacetFactory.getAnnotation(cls, Encodable.class);
        if (annotation != null && (facet2 = new EncodableFacetAnnotation(cls, this.getIsisConfiguration(), holder, this.adapterManager, this.dependencyInjector)).isValid()) {
            return facet2;
        }
        String encoderDecoderName = EncoderDecoderUtil.encoderDecoderNameFromConfiguration(cls, this.getIsisConfiguration());
        if (!StringUtils.isNullOrEmpty((String)encoderDecoderName) && (facet = new EncodableFacetFromConfiguration(encoderDecoderName, holder, this.adapterManager, this.dependencyInjector)).isValid()) {
            return facet;
        }
        return null;
    }

    public IsisConfiguration getIsisConfiguration() {
        return this.configuration;
    }

    public void setIsisConfiguration(IsisConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setAdapterMap(AdapterMap adapterManager) {
        this.adapterManager = adapterManager;
    }

    public void setDependencyInjector(DependencyInjector dependencyInjector) {
        this.dependencyInjector = dependencyInjector;
    }
}

