/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.dirty.method;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.object.dirty.DirtyObjectFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.dirty.method.ClearDirtyObjectFacetViaMethod;
import org.apache.isis.core.progmodel.facets.object.dirty.method.IsDirtyObjectFacetViaMethod;
import org.apache.isis.core.progmodel.facets.object.dirty.method.MarkDirtyObjectFacetViaMethod;

public class DirtyMethodsFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String MARK_DIRTY_PREFIX = "markDirty";
    private static final String CLEAR_DIRTY_PREFIX = "clearDirty";
    private static final String IS_DIRTY_PREFIX = "isDirty";
    private static final String[] PREFIXES = new String[]{"markDirty", "clearDirty", "isDirty"};

    public DirtyMethodsFacetFactory() {
        super(FeatureType.OBJECTS_ONLY, PREFIXES);
    }

    public void process(FacetFactory.ProcessClassContext processClassContext) {
        FacetHolder facetHolder = processClassContext.getFacetHolder();
        Class cls = processClassContext.getCls();
        ArrayList<DirtyObjectFacetAbstract> facets = new ArrayList<DirtyObjectFacetAbstract>();
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, IS_DIRTY_PREFIX, Boolean.TYPE, NO_PARAMETERS_TYPES);
        if (method != null) {
            processClassContext.removeMethod(method);
            facets.add(new IsDirtyObjectFacetViaMethod(method, facetHolder));
        }
        if ((method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, CLEAR_DIRTY_PREFIX, Void.TYPE, NO_PARAMETERS_TYPES)) != null) {
            processClassContext.removeMethod(method);
            facets.add(new ClearDirtyObjectFacetViaMethod(method, facetHolder));
        }
        if ((method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, MARK_DIRTY_PREFIX, Void.TYPE, NO_PARAMETERS_TYPES)) != null) {
            processClassContext.removeMethod(method);
            facets.add(new MarkDirtyObjectFacetViaMethod(method, facetHolder));
        }
        FacetUtil.addFacets(facets);
    }
}

