/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.defaults;

import org.apache.isis.applib.adapters.DefaultsProvider;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjector;
import org.apache.isis.core.progmodel.facets.object.defaults.DefaultedFacet;
import org.apache.isis.core.progmodel.facets.object.defaults.DefaultedFacetUsingDefaultsProvider;
import org.apache.isis.core.progmodel.facets.object.defaults.DefaultsProviderUtil;

public abstract class DefaultedFacetAbstract
extends FacetAbstract
implements DefaultedFacet {
    private final Class<?> defaultsProviderClass;
    private final DefaultedFacetUsingDefaultsProvider defaultedFacetUsingDefaultsProvider;
    private final DependencyInjector dependencyInjector;

    public DefaultedFacetAbstract(String candidateEncoderDecoderName, Class<?> candidateEncoderDecoderClass, FacetHolder holder, DependencyInjector dependencyInjector) {
        super(DefaultedFacet.class, holder, false);
        this.defaultsProviderClass = DefaultsProviderUtil.defaultsProviderOrNull(candidateEncoderDecoderClass, candidateEncoderDecoderName);
        this.dependencyInjector = dependencyInjector;
        if (this.isValid()) {
            DefaultsProvider defaultsProvider = (DefaultsProvider)ClassUtil.newInstance(this.defaultsProviderClass, FacetHolder.class, (Object)holder);
            this.defaultedFacetUsingDefaultsProvider = new DefaultedFacetUsingDefaultsProvider(defaultsProvider, holder, this.getDependencyInjector());
        } else {
            this.defaultedFacetUsingDefaultsProvider = null;
        }
    }

    public boolean isValid() {
        return this.defaultsProviderClass != null;
    }

    public Class<?> getDefaultsProviderClass() {
        return this.defaultsProviderClass;
    }

    @Override
    public Object getDefault() {
        return this.defaultedFacetUsingDefaultsProvider.getDefault();
    }

    protected String toStringValues() {
        return this.defaultsProviderClass.getName();
    }

    private DependencyInjector getDependencyInjector() {
        return this.dependencyInjector;
    }
}

