/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.choices.enums;

import org.apache.isis.core.commons.lang.CastUtils;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.choices.ChoicesFacet;
import org.apache.isis.core.progmodel.facets.object.choices.enums.ChoicesFacetEnum;
import org.apache.isis.core.progmodel.facets.object.choices.enums.EnumValueSemanticsProvider;
import org.apache.isis.core.progmodel.facets.object.value.ValueUsingValueSemanticsProviderFacetFactory;

public class EnumFacetFactory<T extends Enum<T>>
extends ValueUsingValueSemanticsProviderFacetFactory<T> {
    public EnumFacetFactory() {
        super(ChoicesFacet.class);
    }

    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class cls = processClassContext.getCls();
        FacetHolder holder = processClassContext.getFacetHolder();
        if (!cls.isEnum()) {
            return;
        }
        this.addFacets(new EnumValueSemanticsProvider<T>(holder, this.asT(cls), this.getConfiguration(), this.getContext()));
        FacetUtil.addFacet((Facet)new ChoicesFacetEnum(holder, cls.getEnumConstants()));
    }

    protected Class<T> asT(Class<?> cls) {
        return (Class)CastUtils.cast(cls);
    }
}

