/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.hide.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.progmodel.facets.members.hide.HideForContextFacetAbstract;

public class HideForContextFacetViaMethod
extends HideForContextFacetAbstract
implements ImperativeFacet {
    private final Method method;

    public HideForContextFacetViaMethod(Method method, FacetHolder holder) {
        super(holder);
        this.method = method;
    }

    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    public boolean impliesResolve() {
        return true;
    }

    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    public String hiddenReason(ObjectAdapter owningAdapter) {
        if (owningAdapter == null) {
            return null;
        }
        Boolean isHidden = (Boolean)AdapterInvokeUtils.invoke((Method)this.method, (ObjectAdapter)owningAdapter);
        return isHidden != false ? "Hidden" : null;
    }

    protected String toStringValues() {
        return "method=" + this.method;
    }
}

