/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.hide.method;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.members.hide.method.HideForContextFacetViaMethod;

public class HiddenFacetViaHideMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"hide"};

    public HiddenFacetViaHideMethodFacetFactory() {
        super(FeatureType.MEMBERS, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        HiddenFacetViaHideMethodFacetFactory.attachHideFacetIfHideMethodIsFound(processMethodContext);
    }

    public static void attachHideFacetIfHideMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method getMethod = processMethodContext.getMethod();
        String capitalizedName = NameUtils.javaBaseNameStripAccessorPrefixIfRequired((String)getMethod.getName());
        Class cls = processMethodContext.getCls();
        Method hideMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "hide" + capitalizedName, Boolean.TYPE, new Class[0]);
        if (hideMethod == null) {
            return;
        }
        processMethodContext.removeMethod(hideMethod);
        FacetHolder facetedMethod = processMethodContext.getFacetHolder();
        FacetUtil.addFacet((Facet)new HideForContextFacetViaMethod(hideMethod, facetedMethod));
    }
}

