/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.disable.staticmethod;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.metamodel.adapter.util.InvokeUtils;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.members.disable.staticmethod.DisabledFacetAlways;

public class DisabledFacetViaProtectMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"protect"};

    public DisabledFacetViaProtectMethodFacetFactory() {
        super(FeatureType.MEMBERS, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        DisabledFacetViaProtectMethodFacetFactory.attachDisabledFacetIfProtectMethodIsFound(processMethodContext);
    }

    public static void attachDisabledFacetIfProtectMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Class[] paramTypes = new Class[]{};
        Class type = processMethodContext.getCls();
        Method method = processMethodContext.getMethod();
        String capitalizedName = NameUtils.javaBaseNameStripAccessorPrefixIfRequired((String)method.getName());
        Method protectMethod = MethodFinderUtils.findMethodWithOrWithoutParameters(type, MethodScope.CLASS, "protect" + capitalizedName, Boolean.TYPE, paramTypes);
        if (protectMethod == null) {
            return;
        }
        processMethodContext.removeMethod(protectMethod);
        Boolean protectMethodReturnValue = DisabledFacetViaProtectMethodFacetFactory.invokeProtectMethod(protectMethod);
        if (!protectMethodReturnValue.booleanValue()) {
            return;
        }
        FacetHolder facetedMethod = processMethodContext.getFacetHolder();
        FacetUtil.addFacet((Facet)new DisabledFacetAlways(facetedMethod));
    }

    private static Boolean invokeProtectMethod(Method protectMethod) {
        Boolean protectMethodReturnValue = null;
        try {
            protectMethodReturnValue = (Boolean)InvokeUtils.invokeStatic((Method)protectMethod);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (protectMethodReturnValue == null) {
            throw new MetaModelException("method " + protectMethod + "must return a boolean");
        }
        return protectMethodReturnValue;
    }
}

